% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mvord}
\alias{predict.mvord}
\title{Predict method for Multivariate Ordinal Regression Models.}
\usage{
\method{predict}{mvord}(object, type = "prob", subjectID = NULL, ...)
}
\arguments{
\item{object}{an object of class \code{'mvord'}.}

\item{type}{types \code{"class"}, \code{"prob"} and \code{"cum.prob"} are available.}

\item{subjectID}{(optional) vector specifying for which subjectIDs the predictions\cr or fitted values should be computed.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Obtains predicted or fitted values for objects of class \code{'mvord'}.
}
\details{
\tabular{ll}{
  \code{type} \tab description\cr
  \code{"class"} \tab combination of response categories with the highest probability in the fitted model.\cr
  \code{"prob"} \tab (default) fitted joint probability for the observed response categories.\cr
  \code{"cum.prob"} \tab fitted joint cumulative probability for the observed response categories.
  }

The current implementation supports only in-sample predictions.
The row names of the output correspond to the subjectIDs.
}
\seealso{
\code{\link{marginal_predict}}, \code{\link{joint_probabilities}}
}
