% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{faTest}
\alias{faTest}
\title{Rotational Robust Shapiro-Wilk Type (SWT) Test for Multivariate Normality (FA Test of Fattorini)}
\usage{
faTest(X, B = 1000)
}
\arguments{
\item{X}{an \eqn{n*p} data matrix or data frame, where \eqn{n} is number of rows (observations) and \eqn{p} is number of columns (variables) and \eqn{n>p}.}

\item{B}{number of Monte Carlo simulations for null distribution, default is 1000 (increase B to increase the precision of \emph{p}-value).}
}
\value{
Returns a list with two objects:
\describe{
\item{\code{mv.test}}{results of the FA test for multivariate normality, i.e., test statistic,
\emph{p}-value, and multivariate normality summary (YES, if \emph{p}-value>0.05).}
\item{\code{uv.shapiro}}{a dataframe with \eqn{p} rows detailing univariate Shapiro-Wilk tests. Columns in the dataframe contain test statistics \emph{W}, \emph{p}-value,and univariate normality summary (YES, if \emph{p}-value>0.05).}
}
}
\description{
It computes FA Test proposed by Fattorini (1986). This test would be more rotationally robust than other
SWT tests such as Royston (1982) H test and the test proposed by Villasenor-Alva and Gonzalez-Estrada (2009).
The \emph{p}-value of the test statistic is computed based on a
simulated null distribution of the statistic.
}
\examples{
set.seed(12345)

## Data from gamma distribution ##
X = matrix(rgamma(50*4,shape =  2),50)
faTest(X, B=100)

## load the ubiquitous multivariate iris data ##
## (first 50 observations of columns 1:4) ##
iris.df = iris[1:50, 1:4]
faTest(iris.df, B=100)

}
\references{
Fattorini, L. (1986). Remarks on the use of Shapiro-Wilk statistic for testing multivariate normality. \emph{Statistica}, 46(2), 209-217.

Lee, R., Qian, M., & Shao, Y. (2014). On rotational robustness of Shapiro-Wilk type tests for multivariate normality. \emph{Open Journal of Statistics}, 4(11), 964.

Shapiro, S. S., & Wilk, M. B. (1965). An analysis of variance test for normality (complete samples). \emph{Biometrika}, 52(3/4), 591-611.

Royston, J. P. (1982). An extension of Shapiro and Wilk's W test for normality to large samples. \emph{Journal of the Royal Statistical Society: Series C (Applied Statistics)}, 31(2), 115-124.

Villasenor Alva, J. A., & Estrada, E. G. (2009). A generalization of Shapiro–Wilk's test for multivariate normality. \emph{Communications in Statistics—Theory and Methods}, 38(11), 1870-1883.

Zhou, M., & Shao, Y. (2014). A powerful test for multivariate normality. \emph{Journal of applied statistics}, 41(2), 351-363.
}
\seealso{
\code{\link{power.faTest}}, \code{\link{mvnTest}}, \code{\link{msk}}, \code{\link{mardia}}, \code{\link{msw}}, \code{\link{mhz}}
}
