% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear_models.R
\name{lm_mverse}
\alias{lm_mverse}
\title{Fit linear regression models across the multiverse.}
\usage{
lm_mverse(.mverse)
}
\arguments{
\item{.mverse}{a \code{mverse} object.}
}
\value{
A \code{mverse} object with \code{lm} fitted.
}
\description{
\code{lm_mverse} fits \code{lm} across the multiverse
according to model specifications provided by \code{formula_branch}.
At least one \code{formula_branch} must have been added.
}
\examples{
\donttest{

# Fitting \code{lm} models fitted across a multiverse.
hurricane_strength <- mutate_branch(
  NDAM,
  HighestWindSpeed,
  Minpressure_Updated_2014
)
y <- mutate_branch(
  alldeaths, log(alldeaths + 1)
)
hurricane_outliers <- filter_branch(
  !Name \%in\% c("Katrina", "Audrey", "Andrew"),
  TRUE # include all
)
model_specifications <- formula_branch(
  y ~ MasFem,
  y ~ MasFem + hurricane_strength
)
mv <- create_multiverse(hurricane) \%>\%
  add_filter_branch(hurricane_outliers) \%>\%
  add_mutate_branch(hurricane_strength, y) \%>\%
  add_formula_branch(model_specifications) \%>\%
  lm_mverse()
}
}
\seealso{
Other model fitting functions: 
\code{\link{glm.nb_mverse}()},
\code{\link{glm_mverse}()}
}
\concept{model fitting functions}
