% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/musica.R
\name{difs}
\alias{dif}
\alias{difs}
\alias{rev_dif}
\alias{rev_difv}
\title{Functions for evaluating distance between variables}
\usage{
dif(x, y, var)

rev_dif(x, y, var)

rev_difv(x, var)
}
\arguments{
\item{x, y}{variables to be compared}

\item{var}{variable code}
}
\value{
Difference or ratio of \code{x} and \code{y} (for \code{dif}) and sum or product (for \code{rev_dif} and \code{rev_difv}). Distance is measured as difference for variables included in \code{getOption('additive_variables')}, i.e. temperature (\code{TAS}) by default, and as a ratio for other variables.

While \code{rev_dif} returns \code{sum(x, y)} or \code{prod(x, y)}, \code{rev_difv} takes single vector \code{x} and returns \code{sum(x)} or \code{prod(x)}.

Used mainly in other functions of the package.
}
\description{
Functions for evaluating distance between variables
}
\examples{
getOption('additive_variables')

# calculate distance of 2 vectors
dif(c(10, 20, 30), c(11, 18, 3), 'TAS')
dif(c(10, 20, 30), c(11, 18, 3), 'PR')

# inverse for 2 vectors
rev_dif(c(10, 20, 30), c(11, 18, 3), 'TAS')

# inverse for 1 vector
rev_difv(c(10, 1.1, .9), 'TAS')
}

