% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiblock.R
\name{multiblock_biprojector}
\alias{multiblock_biprojector}
\title{Create a Multiblock Bi-Projector}
\usage{
multiblock_biprojector(
  v,
  s,
  sdev,
  preproc = prep(pass()),
  ...,
  block_indices,
  classes = NULL
)
}
\arguments{
\item{v}{A matrix of components (nrow = number of variables, ncol = number of components).}

\item{s}{A matrix of scores (nrow = samples, ncol = components).}

\item{sdev}{A numeric vector of singular values or standard deviations.}

\item{preproc}{A pre-processing object (default: \code{prep(pass())}).}

\item{...}{Extra arguments.}

\item{block_indices}{A list of numeric vectors specifying data block variable indices.}

\item{classes}{Additional class attributes (default NULL).}
}
\value{
A \code{multiblock_biprojector} object.
}
\description{
Constructs a multiblock bi-projector using the given component matrix (\code{v}), score matrix (\code{s}), singular values (\code{sdev}),
a preprocessing function, and a list of block indices. This allows for two-way mapping with multiblock data.
}
\seealso{
bi_projector, multiblock_projector
}
