% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discriminant_projector.R
\name{discriminant_projector}
\alias{discriminant_projector}
\title{Construct a Discriminant Projector}
\usage{
discriminant_projector(
  v,
  s,
  sdev,
  preproc = prep(pass()),
  labels,
  classes = NULL,
  ...
)
}
\arguments{
\item{v}{The projection matrix (often \code{X \%*\% v}). Rows correspond to observations, columns to components.}

\item{s}{The score matrix (often \code{X \%*\% v}). Rows correspond to observations, columns to components.}

\item{sdev}{The standard deviations associated with the scores or components (e.g., singular values from LDA).}

\item{preproc}{A \code{prepper} or \code{pre_processor} object, or a pre-processing function (e.g., \code{center}, \code{pass}).}

\item{labels}{A factor or character vector of class labels corresponding to the rows of \code{X} (and \code{s}).}

\item{classes}{Additional S3 classes to prepend.}

\item{...}{Extra arguments passed to \code{bi_projector}.}
}
\value{
A \code{discriminant_projector} object.
}
\description{
A \code{discriminant_projector} is an instance that extends \code{bi_projector} with a projection that maximizes class separation.
This can be useful for dimensionality reduction techniques that take class labels into account, such as Linear Discriminant Analysis (LDA).
}
\examples{
# Simulate data and labels
set.seed(123)
X <- matrix(rnorm(100 * 10), 100, 10)
labels <- factor(rep(1:2, each = 50))

# Perform LDA and create a discriminant projector
lda_fit <- MASS::lda(X, labels)

dp <- discriminant_projector(lda_fit$scaling, X \%*\% lda_fit$scaling, sdev = lda_fit$svd, 
labels = labels)
}
\seealso{
bi_projector
}
