% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classifier.R
\name{classifier.multiblock_biprojector}
\alias{classifier.multiblock_biprojector}
\title{Multiblock Bi-Projector Classifier}
\usage{
\method{classifier}{multiblock_biprojector}(
  x,
  colind = NULL,
  labels,
  new_data = NULL,
  block = NULL,
  global_scores = TRUE,
  knn = 1,
  ...
)
}
\arguments{
\item{x}{A fitted \code{multiblock_biprojector} object.}

\item{colind}{An optional numeric vector specifying column indices from the original data space.
If provided when \code{global_scores=FALSE}, these indices are used to perform a partial projection for the reference scores.
If provided when \code{global_scores=TRUE}, this value is stored but does not affect the
reference scores (which remain global); however, it may influence the default projection
behavior during prediction unless overridden there. See \code{predict.classifier}.}

\item{labels}{A factor or vector of class labels for the training data.}

\item{new_data}{An optional data matrix used to generate reference scores when \code{global_scores=FALSE},
or when \code{global_scores=TRUE} but \code{colind} or \code{block} is also provided (overriding \code{global_scores}).
Must be provided if \code{global_scores=FALSE}.}

\item{block}{An optional integer specifying a predefined block index.
Used for partial projection if \code{global_scores=FALSE} or if \code{new_data} is also provided.
Cannot be used simultaneously with \code{colind}.}

\item{global_scores}{Logical. \strong{DEPRECATED} This argument is deprecated and its behavior has changed.
Reference scores are now determined automatically:
\itemize{
\item If \code{new_data} is NULL: Uses the globally projected scores stored in \code{x} (\code{scores(x)}).
\item If \code{new_data} is provided: Always projects \code{new_data} to generate reference scores
(using \code{partial_project}/\code{project_block} if \code{colind}/\code{block} are given, \code{project} otherwise).
}}

\item{knn}{The integer number of nearest neighbors (k) for the k-NN algorithm (default: 1).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{multiblock_classifier}, which also inherits from \code{classifier}.
}
\description{
Constructs a k-Nearest Neighbors (k-NN) classifier based on a fitted
\code{multiblock_biprojector} model object. The classifier uses the projected scores
as the feature space for k-NN.
}
\details{
Users can specify whether to use the globally projected scores stored within the model
(\code{global_scores = TRUE}) or to generate reference scores by projecting provided \code{new_data}
(\code{global_scores = FALSE}). Partial projections based on \code{colind} or \code{block} can be used
when \code{global_scores = FALSE} or when \code{new_data} is provided alongside \code{colind}/\code{block}.
Prediction behavior is further controlled by arguments passed to \code{predict.classifier}.
}
\seealso{
Other classifier: 
\code{\link{classifier}()},
\code{\link{rf_classifier.projector}()}
}
\concept{classifier}
