% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariance-functions.R
\name{resample.multivariance}
\alias{resample.multivariance}
\title{resampling (total /m-) multivariance}
\usage{
resample.multivariance(x, vec = 1:ncol(x), times = 300,
  type = "multi", resample.type = "permutation", ...)
}
\arguments{
\item{x}{matrix, the rows should be iid samples}

\item{vec}{vector, which indicates which columns of \code{x} are treated together as one sample}

\item{times}{integer, number of samples to generate}

\item{type}{one of \code{"multi","total","m.multi.2","m.multi.3"}}

\item{resample.type}{one of \code{"permutation", "bootstrap"}. The samples are generated without replacement (permutations) or with replacement (bootstrap).}

\item{...}{is passed to \code{\link{cdms}, \link{multivariance}, \link{total.multivariance}, \link{m.multivariance}}, respectively.}
}
\value{
A list with elements
\describe{
  \item{\code{resampled}}{the (total/m-)multivariances of the resampled data,}
  \item{\code{original}}{the (total/m-)multivariance of the original data,}
  \item{\code{p.value}}{the p-value of the original data, computed using the resampled data}
}
}
\description{
The distribution of the test statistic under the hypothesis of independence is required for the independence tests. This function generates approximate samples of this distribution either by sampling without replacement (permutations) or by sampling with replacement (bootstrap).
}
\details{
The resampling is done by sampling from the original data either without replacement (\code{"permutation"}) or with replacement (\code{"bootstrap"}).

For convenience also the actual (total /m-) multivariance is computed and its p-value.
}
\examples{
re.m = resample.multivariance(matrix(rnorm(30*2),nrow = 30),
                        type= "multi",times = 300)$resampled
curve(ecdf(re.m)(x), xlim = c(0,4),main = "empirical distribution of the test statistic under H_0")
}
\references{
For the theoretic background see the reference [3] given on the main help page of this package: \link{multivariance-package}.
}
