% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.R
\name{build.sbp}
\alias{build.sbp}
\title{Build Sequential Binary Partition}
\usage{
build.sbp(parts)
}
\arguments{
\item{parts}{A character vector specifying the names of compositional variables to be used.}
}
\value{
A matrix sequential binary partition.
}
\description{
Build a default sequential binary partition for \code{complr} object.
The default sequential binary partition is a pivot balance that allows
the effect of this first balance coordinate to be interpreted as the change
in the prediction for the dependent variable
when that given part increases while all remaining parts decrease by a common proportion.
}
\examples{
sbp1 <- build.sbp(parts = c("TST", "WAKE", "MVPA", "LPA", "SB"))
print(sbp1)

sbp2 <- build.sbp(c("WAKE", "MVPA", "LPA", "SB"))
print(sbp2)
}
