% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bt_test_mf.R
\name{bt_test_mf}
\alias{bt_test_mf}
\title{bt_test_mf}
\usage{
bt_test_mf(
  cs1,
  cs2,
  data,
  subj,
  group = NULL,
  na.rm = FALSE,
  paired = TRUE,
  rscale = "medium",
  phase = "acquisition",
  dv = "scr",
  exclusion = "full data",
  cut_off = "full data"
)
}
\arguments{
\item{cs1}{The column name(s) of the conditioned responses for the first conditioned stimulus}

\item{cs2}{The column name(s) of the conditioned responses for the second conditioned stimulus}

\item{data}{A data frame containing all the relevant columns for the analyses}

\item{subj}{The name of the column including the participant numbers. Unique numbers are expected}

\item{group}{the name of the group, if included, default to \code{NULL}}

\item{na.rm}{Whether NAs should be removed, default to \code{FALSE}}

\item{paired}{Whether the t-test refers to dependent (i.e., paired) or to independent sample(s). Default to \code{TRUE}}

\item{rscale}{r scale to be used in the prior of the alternative hypothesis, default to "medium".}

\item{phase}{The conditioned phase that the analyses refer to. Accepted values are  \code{acquisition}, \code{acq}, \code{extinction}, or \code{ext}}

\item{dv}{name of the measured conditioned response. Default to \code{"SCR"}}

\item{exclusion}{Name of the data reduction procedure used. Default to \code{full data}}

\item{cut_off}{cut off Name of the cut_off applied. Default to \code{full data}}
}
\value{
A tibble with the following column names:

x: the name of the independent variable (e.g., cs)

y: the name of the dependent variable as this defined in the \code{dv} argument

exclusion: see \code{exclusion} argument

model: the model that was run (e.g., t-test)

controls: ignore this column for this test

method: the model that was run

p.value: irrelevant here

effect.size: irrelevant here

effect.size.ma: irrelevant here

estimate: the estimate of the test run

statistic: the t-value

conf.low: the lower confidence interval for the estimate

conf.high: the higher confidence interval for the estimate

framework: were the data analysed within a NHST or Bayesian framework?

data_used: a list with the data used for the specific test
}
\description{
Basic function for running the Bayesian t-tests included in the main analyses
}
\details{
This is a wrapper function function around the \code{BayesFactor::ttestBF(),}
running multiple Bayesian t-tests. Similar to the \code{t_test_mf} function, the function will run different t-tests based on the phase that the t-tests refer to. So, in case of the acquisition phase, there will be a t-test of differences and positive differences, whereas for the extinction phase a t-test for differences and negative differences.
}
\examples{
# Load example data
data(example_data)

# Paired sample t-tests
bt_test_mf(cs1 = "CSP1", cs2 = "CSM1", subj = "id", data = example_data)

# Independent  sample t-tests
bt_test_mf(cs1 = "CSP1", cs2 = "CSM1", subj = "id",  group = "group", data = example_data)

}
