% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_functions.R
\name{get_multiOmics_diffNetworks}
\alias{get_multiOmics_diffNetworks}
\title{Get a table of all significant interactions across categories}
\usage{
get_multiOmics_diffNetworks(deggs_object, sig_threshold = 0.05)
}
\arguments{
\item{deggs_object}{an object of class \code{deggs} generated by
\code{get_diffNetworks}}

\item{sig_threshold}{threshold for significance. Default 0.05.}
}
\value{
a list of multilayer networks (as edge tables), one per
category.
}
\description{
Get a table of all significant interactions across categories
}
\examples{
data("synthetic_metadata")
data("synthetic_rnaseqData")
data("synthetic_proteomicData")
data("synthetic_OlinkData")
assayData_list <- list("RNAseq" = synthetic_rnaseqData,
                       "Proteomics" = synthetic_proteomicData,
                       "Olink" = synthetic_OlinkData)
deggs_object <- get_diffNetworks(assayData = assayData_list,
                                 metadata = synthetic_metadata,
                                 category_variable = "response",
                                 verbose = FALSE,
                                 show_progressBar = FALSE,
                                 cores = 2)
get_multiOmics_diffNetworks(deggs_object, sig_threshold = 0.05)
}
