% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtar.R
\name{mtar}
\alias{mtar}
\title{Bayesian estimation of a multivariate threshold autoregressive (TAR) model.}
\usage{
mtar(
  formula,
  data,
  subset,
  Intercept = TRUE,
  ars,
  row.names,
  dist = "Gaussian",
  prior = list(),
  n.sim = 500,
  n.burnin = 100,
  n.thin = 1,
  log = FALSE,
  ...
)
}
\arguments{
\item{formula}{a three-part expression of type \code{Formula} describing the TAR model
to be fitted to the data. In the first part, the variables in the
multivariate output series are listed; in the second part, the threshold
series is specified, and in the third part, the variables in the
multivariate exogenous series are specified.}

\item{data}{an (optional) data frame, list or environment (or object coercible by
\link{as.data.frame} to a data frame) containing the variables in the model.
If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{mtar} is called.}

\item{subset}{an (optional) vector specifying a subset of observations to be used in the
fitting process.}

\item{Intercept}{an (optional) logical variable. If \code{TRUE}, then the model
includes an intercept.}

\item{ars}{a list composed of three objects, namely: \code{p}, \code{q} and \code{d},
each of which corresponds to a vector of non-negative integers with as many
elements as there are regimes in the TAR model.}

\item{row.names}{an (optional) vector that allows the user to name the time point to
which each row in the data set corresponds.}

\item{dist}{an (optional) character string that allows the user to specify the multivariate
distribution to be used to describe the behavior of the noise process. The
available options are: Gaussian ("Gaussian"), Student-\eqn{t} ("Student-t"),
Slash ("Slash"), Symmetric Hyperbolic ("Hyperbolic"), Laplace ("Laplace"), and
contaminated normal ("Contaminated normal"). As default, \code{dist} is set to
"Gaussian".}

\item{prior}{an (optional) list that allows the user to specify the values of the
hyperparameters, that is, allows to specify the values of the parameters
of the prior distributions.}

\item{n.sim}{an (optional) positive integer specifying the required number of iterations
for the simulation after the burn-in period. As default, \code{n.sim} is set
to 500.}

\item{n.burnin}{an (optional) positive integer specifying the required number of burn-in
iterations for the simulation. As default, \code{n.burnin} is set to 100.}

\item{n.thin}{an (optional) positive integer specifying the required thinning interval
for the simulation. As default, \code{n.thin} is set to 1.}

\item{log}{an (optional) logical variable. If \code{TRUE}, then the behaviour of the output
series is described using the exponentiated version of \code{dist}.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
an object of class \emph{mtar} in which the main results of the model fitted to the data are stored, i.e., a
list with components including
\tabular{ll}{
\code{chains}   \tab list with several arrays, which store the values of each model parameter in each iteration of the simulation,\cr
\tab \cr
\code{n.sim}    \tab number of iterations of the simulation after the burn-in period,\cr
\tab \cr
\code{n.burnin} \tab number of burn-in iterations in the simulation,\cr
\tab \cr
\code{n.thin}   \tab thinning interval in the simulation,\cr
\tab \cr
\code{regim}    \tab number of regimes, \cr
\tab \cr
\code{ars}      \tab list composed of three objects, namely: \code{p}, \code{q} and \code{d},
                     each of which corresponds to a vector of non-negative integers with as
                     many elements as there are regimes in the TAR model,\cr
\tab \cr
\code{dist}     \tab name of the multivariate distribution used to describe the behavior of
                     the noise process,\cr
\tab \cr
\code{threshold.series}  \tab vector with the values of the threshold series,\cr
\tab \cr
\code{response.series}   \tab matrix with the values of the output series,\cr
\tab \cr
\code{covariable.series} \tab matrix with the values of the exogenous series,\cr
\tab \cr
\code{Intercept}    \tab If \code{TRUE}, then the model included an intercept term,\cr
\tab \cr
\code{formula}      \tab the formula,\cr
\tab \cr
\code{call}         \tab the original function call.\cr
}
}
\description{
This function uses Gibbs sampling to generate a sample from the posterior
             distribution of the parameters of a multivariate TAR model when the noise
             process follows Gaussian, Student-\eqn{t}, Slash, Symmetric Hyperbolic,
             Contaminated normal, or Laplace distribution.
}
\examples{
\donttest{
###### Example 1: Returns of the closing prices of three financial indexes
data(returns)
fit1 <- mtar(~ COLCAP + BOVESPA | SP500, row.names=Date, dist="Slash",
             data=returns, ars=list(p=c(1,1,2)), n.burnin=100, n.sim=3000)
summary(fit1)

###### Example 2: Rainfall and two river flows in Colombia
data(riverflows)
fit2 <- mtar(~ Bedon + LaPlata | Rainfall, row.names=Date, dist="Laplace",
             data=riverflows, ars=list(p=c(5,5,5)), n.burnin=100, n.sim=3000)
summary(fit2)
}

}
\references{
Nieto, F.H. (2005) Modeling Bivariate Threshold Autoregressive Processes in the Presence of Missing Data.
            Communications in Statistics - Theory and Methods, 34, 905-930.

Romero, L.V. and Calderon, S.A. (2021) Bayesian estimation of a multivariate TAR model when the noise
            process follows a Student-t distribution. Communications in Statistics - Theory and Methods, 50, 2508-2530.

Calderon, S.A. and Nieto, F.H. (2017) Bayesian analysis of multivariate threshold autoregressive models
            with missing data. Communications in Statistics - Theory and Methods, 46, 296-318.
}
\seealso{
\link{DIC}, \link{WAIC}
}
