% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_ontology_mappings.R
\name{read_ontology_mappings}
\alias{read_ontology_mappings}
\title{Reads ontology_mappings.txt from OncoTree's GitHub repository}
\usage{
read_ontology_mappings(
  url = ontology_mapping_url(),
  fix_names = TRUE,
  list_columns = TRUE
)
}
\arguments{
\item{url}{URL of `ontology_mappings.txt`.}

\item{fix_names}{Whether to convert column names to lowercase, snakecase.}

\item{list_columns}{Whether to return multi-value variables as list-columns.}
}
\value{
A [tibble][tibble::tibble-package] of six variables:
\describe{
\item{`oncotree_code`}{OncoTree code.}
\item{`nci_code`}{National Cancer Institute (NCI) Thesaurus code.}
\item{`umls_code`}{Unified Medical Language System (UMLS) code.}
\item{`icdo_topography_code`}{ICD-O topography code.}
\item{`icdo_morphology_code`}{ICD-O morphology code.}
\item{`hemeonc_code`}{HemeOnc code.}
}
}
\description{
Reads `ontology_mappings.txt` from OncoTree's GitHub repository and returns
its contents as a tibble.
}
\examples{
\dontrun{
# Import ontology_mappings.txt as tibble
read_ontology_mappings()

# Do not convert column names, i.e. keep them as originally in the file
read_ontology_mappings(fix_names = FALSE)

# Keep multi-value columns as originally, i.e. as comma-separated values
read_ontology_mappings(list_columns = FALSE)
}
}
\keyword{internal}
