% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-msaenet.R
\name{predict.msaenet}
\alias{predict.msaenet}
\title{Make Predictions from an AENet/MSAENet Model}
\usage{
\method{predict}{msaenet}(object, newx, ...)
}
\arguments{
\item{object}{An object of class \code{msaenet} produced
by \code{\link{aenet}} or \code{\link{msaenet}}.}

\item{newx}{New data to predict with.}

\item{...}{Additional parameters for \code{\link{predict}}.}
}
\value{
Numeric matrix of the predicted values.
}
\description{
Make predictions on new data by an AENet/MSAENet model object.
}
\examples{
dat = msaenet.sim.gaussian(n = 150, p = 500, rho = 0.6,
                           coef = rep(1, 5), snr = 2, p.train = 0.7,
                           seed = 1001)

msaenet.fit = msaenet(dat$x.tr, dat$y.tr,
                      alphas = seq(0.2, 0.8, 0.2),
                      nsteps = 3L, seed = 1003)

msaenet.pred = predict(msaenet.fit, dat$x.te)
msaenet.rmse(dat$y.te, msaenet.pred)
}
\author{
Nan Xiao <\url{http://nanx.me}>
}

