% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{annotatemrbin}
\alias{annotatemrbin}
\title{A function for annotating mrbin objects.}
\usage{
annotatemrbin(
  mrbinObject,
  annotate = TRUE,
  metaboliteIdentities = NULL,
  add = FALSE,
  hideChemicalShift = FALSE,
  hideTentativeIds = TRUE,
  confirmationRthreshold = 0.6,
  confirmationPthreshold = 5e-06,
  uniqueBins = TRUE,
  checkBaselineCorrelation = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{mrbinObject}{An mrbin object}

\item{annotate}{If FALSE, the mrbin object will not be changed.}

\item{metaboliteIdentities}{A numeric 4-column matrix or the file path for a .csv file containing such a matrix, the first columns containing metabolite names and the first row being a header. Each row belongs to one unique metabolite signal (left, right, top, bottom borders). Row names are metabolite names. If provided, this will overwrite any current metaboliteIdentities matrix present in the mrbin object. If missing, data currently attached to the mrbin object (if any) will be used.}

\item{add}{Should the new metabolite list be added to an existing list, or replace the current list?}

\item{hideChemicalShift}{Should the chemical shift (bin borders) of an identified metabolite be removed, leaving only the metabolite id, or should both be shown? Showing both helps in identifying signals of interest, but hiding the chemical shift might make better plots.}

\item{hideTentativeIds}{Should the identities of tentative ids be omitted for clarity?}

\item{confirmationRthreshold}{A threshold to define the r-value cutoff to confirm an annotation}

\item{confirmationPthreshold}{A threshold to define the p-value cutoff to confirm an annotation}

\item{uniqueBins}{Should each bin be uniquely assigned to only one molecule?}

\item{checkBaselineCorrelation}{Should correlation to baseline be compared to confirm an annotation}

\item{verbose}{Should outputs be shown or suppressed?}
}
\value{
An (invisible) mrbin object
}
\description{
This function annotates an mrbin object and returns it with updated $annotations vector
}
\examples{
 results<-mrbin(silent=TRUE,
                   parameters=list(verbose=TRUE,dimension="1D",PQNScaling="No",
                   binwidth1D=0.04,signal_to_noise1D=1,PCA="No",binRegion=c(9.5,0.5,10,156),
                   saveFiles="No",referenceScaling="No",noiseRemoval="No",
                   fixNegatives="No",logTrafo="No",noiseThreshold=.05,tryParallel=TRUE,
                   NMRfolders=c(system.file("extdata/3/10/pdata/10",package="mrbin"),
                              system.file("extdata/2/10/pdata/10",package="mrbin"),
                              system.file("extdata/1/10/pdata/10",package="mrbin"))))
metaboliteIdentities=matrix(c(1.346,1.324,21,23,1,1,
                              3.052,3.043,30.5,33.5,1,1),
                   ncol=6,byrow=TRUE)
rownames(metaboliteIdentities)=c("Lactate","Creatinine")
colnames(metaboliteIdentities)=c("left","right","top","bottom","usePeak1D","usePeak2D")
results<-annotatemrbin(results,metaboliteIdentities=metaboliteIdentities)
results$metadata$annotations[125:135]
plotPCA(results,loadings=TRUE)
}
