\name{print.mpolyList}
\alias{print.mpolyList}
\title{Pretty printing of a list of multivariate polynomials.}
\usage{
  \method{print}{mpolyList}(x, varorder = vars(x), order,
    ...)
}
\arguments{
  \item{x}{an object of class mpolyList}

  \item{varorder}{the order of the variables}

  \item{order}{a total order used to order the monomials in
  the printing}

  \item{...}{arguments to pass to print.mpoly}
}
\value{
  Invisible character vector of the printed objects.
}
\description{
  This function iterates print.mpoly on an object of class
  mpolyList.
}
\examples{
mL <- mp(c('x + 1', 'y - 1', 'x y^2 z  +  x^2 z^2  +  z^2  +  x^3'))
mL
print(mL, order = 'lex')
print(mL, order = 'glex')
print(mL, order = 'grlex')
print(mL, order = 'glex', varorder = c('z','y','x'))
print(mL, order = 'grlex', varorder = c('z','y','x'))
print(mL, varorder = c('z','y','x'))
s <- print(mL, varorder = c('z','y','x'))
str(s)
}

