% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_sims.R
\name{simulating_data}
\alias{simulating_data}
\title{Simulate Movement Data from Fitted Models}
\usage{
simulating_data(rv)
}
\arguments{
\item{rv}{A reactive values list containing:
\itemize{
\item \code{dur} - A list specifying the sampling duration (\code{value} and \code{unit}).
\item \code{dti} - A list specifying the time interval between locations (\code{value} and \code{unit}).
\item \code{data_type} - A character string indicating data type.
\item \code{is_emulate} - Logical; if \code{TRUE}, the function generates an emulated model.
\item \code{modList} - A list of fitted movement models for simulation.
\item \code{meanfitList} - A list of a mean model for emulation.
\item \code{grouped} - Logical; if \code{TRUE}, the simulation considers grouped movement models.
\item \code{which_meta} - A character vector indicating whether to compare models.
\item \code{tau_p}, \code{tau_v}, \code{sigma}, \code{mu} - Lists of movement model parameters.
\item \code{seed0} - An integer used for random seed initialization.
}}
}
\value{
A list containing one or two simulated movement datasets (depending on grouping):
\itemize{
\item If \code{grouped = FALSE}, returns a list with a single simulated dataset.
\item If \code{grouped = TRUE}, returns a list with two simulated datasets (for groups \code{A} and \code{B}).
}
}
\description{
This function generates simulated location data using movement
models. The function supports both single and grouped simulations based on
whether the data is simulated or derived from an emulated or fitted model.
}
\details{
The function first constructs a time sequence based on the provided duration and interval.
If the data is fully simulated from scratch (not conditioned on existing data), it retrieves
movement model(s) from \code{rv$modList}.
Otherwise, it either emulates a model using \code{rv$meanfitList} and a random seed
or constructs a model from movement parameters.

If estimate comparisons are enabled (via \code{which_meta}), two models are prepared.
The function then runs \code{ctmm::simulate()} to generate simulated movement data.
The resulting trajectories are pseudonymized before returning.
}
