% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moezipfR.utils.getInitialValues.R
\name{moezipfR.utils.getInitialValues}
\alias{moezipfR.utils.getInitialValues}
\title{Calculates initial values for the \eqn{\alpha} and \eqn{\beta} parameters.}
\usage{
moezipfR.utils.getInitialValues(data)
}
\arguments{
\item{data}{Matrix of count data.}
}
\value{
Returns the initial value for parameters \eqn{\alpha} and \eqn{\beta}.
}
\description{
The initial value of the parameters are computed using the empirical absolute frequencies of values
one and two. The selection of robust initial values allows to reduce the number
of iterations which in turn, reduces the computation time.
In the case where one of the two first positive integer values does not appear in the data
set, the default values are set equal to \eqn{\alpha} = 1.0001 and \eqn{\beta} = 0.0001.
}
\details{
The argument \code{data} is a matrix where, for each row, the first column corresponds to a count,
and the second column contains its corresponding frequency.

To obtain the initial value for \eqn{\alpha} and \eqn{\beta}, one will assume that
the data come from a Zipf(\eqn{\alpha}) distribution. Thus, the initial value for \eqn{\beta}
is set equal to one, and the inital value for \eqn{\alpha}, denoted by \eqn{\alpha_0}, is obtained
equating the ratio of the theoretical probabilities at one and two to the corresponding emprirical
ratio. Thus,

\deqn{\alpha_0 = log_2 \big (\frac{f_1}{f_2} \big)}
where \eqn{f_1} and \eqn{f_2} are the absolute frequencies of one and two in the sample.
}
\examples{
data <- rmoezipf(100, 2.5, 1.3)
data <- moezipfR.utils.getDataMatrix(data)
initials <- moezipfR.utils.getInitialValues(data)
}
\references{
{ Güney, Y., Tuaç, Y., & Arslan, O. (2016). Marshall–Olkin distribution: parameter estimation and
application to cancer data. Journal of Applied Statistics, 1-13.}
}
\seealso{
\code{\link{moezipfR.utils.getDataMatrix}}
}

