% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-ts_params.R
\name{time_series_params}
\alias{time_series_params}
\alias{seasonal_period}
\title{Tuning Parameters for Time Series (ts-class) Models}
\usage{
seasonal_period(values = c("none", "daily", "weekly", "yearly"))
}
\arguments{
\item{values}{A time-based phrase}
}
\description{
Tuning Parameters for Time Series (ts-class) Models
}
\details{
Time series models (e.g. \code{Arima()} and \code{ets()}) use \code{\link[stats:ts]{stats::ts()}} or \code{\link[forecast:msts]{forecast::msts()}}
to apply seasonality. We can do the same process using the following
general time series parameter:
\itemize{
\item \code{period}: The periodic nature of the seasonality.
}

It's usually best practice to \emph{not} tune this parameter, but rather set
to obvious values based on the seasonality of the data:
\itemize{
\item \strong{Daily Seasonality:} Often used with \strong{hourly data} (e.g. 24 hourly timestamps per day)
\item \strong{Weekly Seasonality:} Often used with \strong{daily data} (e.g. 7 daily timestamps per week)
\item \strong{Yearly Seasonalty:} Often used with \strong{weekly, monthly, and quarterly data}
(e.g. 12 monthly observations per year).
}

However, in the event that users want to experiment with period tuning, you
can do so with \code{seasonal_period()}.
}
\examples{
seasonal_period()



}
