% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeltime-calibrate.R
\name{modeltime_calibrate}
\alias{modeltime_calibrate}
\title{Preparation for forecasting}
\usage{
modeltime_calibrate(object, new_data, id = NULL, quiet = TRUE, ...)
}
\arguments{
\item{object}{A fitted model object that is either:
\enumerate{
\item A modeltime table that has been created using \code{\link[=modeltime_table]{modeltime_table()}}
\item A workflow that has been fit by \code{\link[=fit.workflow]{fit.workflow()}} or
\item A parsnip model that has been fit using \code{\link[=fit.model_spec]{fit.model_spec()}}
}}

\item{new_data}{A test data set \code{tibble} containing future information (timestamps and actual values).}

\item{id}{A quoted column name containing an identifier column identifying time series that are grouped.}

\item{quiet}{Hide errors (\code{TRUE}, the default), or display them as they occur?}

\item{...}{Additional arguments passed to \code{\link[=modeltime_forecast]{modeltime_forecast()}}.}
}
\value{
A Modeltime Table (\code{mdl_time_tbl}) with nested \code{.calibration_data} added
}
\description{
Calibration sets the stage for accuracy and forecast confidence
by computing predictions and residuals from out of sample data.
}
\details{
The results of calibration are used for:
\itemize{
\item \strong{Forecast Confidence Interval Estimation}: The out of sample residual data is used to calculate the
confidence interval. Refer to \code{\link[=modeltime_forecast]{modeltime_forecast()}}.
\item \strong{Accuracy Calculations:} The out of sample actual and prediction values are used to calculate
performance metrics. Refer to \code{\link[=modeltime_accuracy]{modeltime_accuracy()}}
}

The calibration steps include:
\enumerate{
\item If not a Modeltime Table, objects are converted to Modeltime Tables internally
\item Two Columns are added:
}
\itemize{
\item \code{.type}: Indicates the sample type. This is:
\itemize{
\item "Test" if predicted, or
\item "Fitted" if residuals were stored during modeling.
}
\item \code{.calibration_data}:
\itemize{
\item Contains a tibble with Timestamps, Actual Values, Predictions and Residuals
calculated from \code{new_data} (Test Data)
\item If \code{id} is provided, will contain a 5th column that is the identifier variable.
}
}
}
\examples{
library(tidyverse)
library(lubridate)
library(timetk)
library(parsnip)
library(rsample)
library(modeltime)

# Data
m750 <- m4_monthly \%>\% filter(id == "M750")

# Split Data 80/20
splits <- initial_time_split(m750, prop = 0.8)

# --- MODELS ---

# Model 1: prophet ----
model_fit_prophet <- prophet_reg() \%>\%
    set_engine(engine = "prophet") \%>\%
    fit(value ~ date, data = training(splits))


# ---- MODELTIME TABLE ----

models_tbl <- modeltime_table(
    model_fit_prophet
)

# ---- CALIBRATE ----

calibration_tbl <- models_tbl \%>\%
    modeltime_calibrate(
        new_data = testing(splits)
    )

# ---- ACCURACY ----

calibration_tbl \%>\%
    modeltime_accuracy()

# ---- FORECAST ----

calibration_tbl \%>\%
    modeltime_forecast(
        new_data    = testing(splits),
        actual_data = m750
    )


}
