% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dials-arima_params.R
\name{arima_params}
\alias{arima_params}
\alias{non_seasonal_ar}
\alias{non_seasonal_differences}
\alias{non_seasonal_ma}
\alias{seasonal_ar}
\alias{seasonal_differences}
\alias{seasonal_ma}
\title{Tuning Parameters for ARIMA Models}
\usage{
non_seasonal_ar(range = c(0L, 5L), trans = NULL)

non_seasonal_differences(range = c(0L, 2L), trans = NULL)

non_seasonal_ma(range = c(0L, 5L), trans = NULL)

seasonal_ar(range = c(0L, 2L), trans = NULL)

seasonal_differences(range = c(0L, 1L), trans = NULL)

seasonal_ma(range = c(0L, 2L), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
Tuning Parameters for ARIMA Models
}
\details{
The main parameters for ARIMA models are:
\itemize{
\item \code{non_seasonal_ar}: The order of the non-seasonal auto-regressive (AR) terms.
\item \code{non_seasonal_differences}: The order of integration for non-seasonal differencing.
\item \code{non_seasonal_ma}: The order of the non-seasonal moving average (MA) terms.
\item \code{seasonal_ar}: The order of the seasonal auto-regressive (SAR) terms.
\item \code{seasonal_differences}: The order of integration for seasonal differencing.
\item \code{seasonal_ma}: The order of the seasonal moving average (SMA) terms.
}
}
\examples{
non_seasonal_ar()

non_seasonal_differences()

non_seasonal_ma()


}
