% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_grouplevel.R, R/reshape_grouplevel.R
\name{estimate_grouplevel}
\alias{estimate_grouplevel}
\alias{reshape_grouplevel}
\title{Group-specific parameters of mixed models random effects}
\usage{
estimate_grouplevel(model, type = "random", ...)

reshape_grouplevel(x, indices = "all", group = "all", ...)
}
\arguments{
\item{model}{A mixed model with random effects.}

\item{type}{If \code{"random"} (default), the coefficients are the ones
estimated natively by the model (as they are returned by, for instance,
\code{lme4::ranef()}). They correspond to the deviation of each individual
group from their fixed effect. As such, a coefficient close to 0 means that
the participants' effect is the same as the population-level effect (in
other words, it is "in the norm"). If "total", it will return the sum of
the random effect and its corresponding fixed effects. These are known as
BLUPs (Best Linear Unbiased Predictions). This argument can be used to
reproduce the results given by \code{lme4::ranef()} and \code{coef()} (see
\code{?coef.merMod}). Note that BLUPs currently don't have uncertainty
indices (such as SE and CI), as these are not computable.}

\item{...}{Other arguments passed to or from other methods.}

\item{x}{The output of \code{estimate_grouplevel()}.}

\item{indices}{A list containing the indices to extract (e.g., "Coefficient").}

\item{group}{A list containing the random factors to select.}
}
\description{
Extract random parameters of each individual group in the context of mixed
models. Can be reshaped to be of the same dimensions as the original data,
which can be useful to add the random effects to the original data.
}
\examples{
# lme4 model
if (require("lme4") && require("see")) {
  model <- lmer(mpg ~ hp + (1 | carb), data = mtcars)
  random <- estimate_grouplevel(model)
  random

  # Visualize random effects
  plot(random)

  # Show group-specific effects
  estimate_grouplevel(model, deviation = FALSE)

  # Reshape to wide data so that it matches the original dataframe...
  reshaped <- reshape_grouplevel(random, indices = c("Coefficient", "SE"))

  # ... and can be easily combined
  alldata <- cbind(mtcars, reshaped)

  # Use summary() to remove duplicated rows
  summary(reshaped)

  # Compute BLUPs
  estimate_grouplevel(model, type = "total")
}

# Bayesian models
\donttest{
if (require("rstanarm")) {
  model <- rstanarm::stan_lmer(mpg ~ hp + (1 | carb) + (1 | gear), data = mtcars, refresh = 0)
  # Broken estimate_grouplevel(model)
}
}
}
