% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A09_modelObjFit.R
\docType{methods}
\name{fitObject}
\alias{fitObject}
\alias{fitObject,modelObjFit-method}
\title{Retrieve Regression Object}
\usage{
fitObject(object, ...)

\S4method{fitObject}{modelObjFit}(object, ...)
}
\arguments{
\item{object}{An object of class modelObjFit.}

\item{...}{ignored.}
}
\value{
The Value returned by the regression method specified in the 
  governing modelObj. The exact structure of the value will depend on the 
  regression method. For example, if nls() is the regression method, a list 
  is returned.
}
\description{
Retrieves the value object returned by the regression method used to obtain 
  parameter estimates.
}
\details{
This function is useful for accessing methods that are defined by the 
  regression method but are not directly accessible from the modelObjFit 
  object. For example, for many regression methods, users can retrieve the 
  fitted values by calling fitted.values(object). This method is not 
  directly accessible from a modelObjFit. However, fitted.values() can be 
  applied to the object returned by fitObject().
}
\examples{
   # Generate data
   X <- matrix(rnorm(1000,0,1),
               ncol=4,
               dimnames=list(NULL,c("X1","X2","X3","X4")))

   Y <- X \\\%*\\\% c(0.1, 0.2, 0.3, 0.4) + rnorm(250)

   X <- data.frame(X)

   # Create modeling object using a formula
   mo <- buildModelObj(model=Y ~ X1 + X2 + X3 + X4,
                       solver.method='lm')

   # Fit model
   fit.obj <- fit(object=mo, data=X, response=Y)

   obj <- fitObject(fit.obj)
   fobj <- fitted.values(obj)
   head(fobj)

}
