% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionRegr.R
\name{autoplot.PredictionRegr}
\alias{autoplot.PredictionRegr}
\title{Plot for PredictionRegr}
\usage{
\method{autoplot}{PredictionRegr}(object, type = "xy", ...)
}
\arguments{
\item{object}{(\link[mlr3:PredictionRegr]{mlr3::PredictionRegr}).}

\item{type}{(character(1)):\cr
Type of the plot. See description.}

\item{...}{(\code{any}):
Additional arguments, passed down to the respective \code{geom}.}
}
\value{
\code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object.
}
\description{
Generates plots for \link[mlr3:PredictionRegr]{mlr3::PredictionRegr}, depending on argument \code{type}:
\itemize{
\item \code{"xy"} (default): Scatterplot of true response vs predicted response.
Additionally fits a linear model to visualize a possible trend.
\item \code{"histogram"}: Histogram of residuals \eqn{r = y - \hat{y}}{r = y - y.hat}.
}
}
\examples{
library(mlr3)
library(mlr3viz)

task = tsk("boston_housing")
learner = lrn("regr.rpart")
object = learner$train(task)$predict(task)

head(fortify(object))
autoplot(object)
autoplot(object, type = "histogram", binwidth = 1)
}
