% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasureCI.R
\name{mlr_measures_ci}
\alias{mlr_measures_ci}
\alias{MeasureCi}
\title{Default CI Method}
\description{
For certain resampling methods, there are default confidence interval methods.
See \code{mlr3::mlr_reflections$default_ci_methods} for a selection.
This measure will select the appropriate CI method depending on the class of the
used \code{\link[mlr3:Resampling]{Resampling}}.
}
\section{Parameters}{

Only those from \code{\link{MeasureAbstractCi}}.
}

\examples{
rr = resample(tsk("sonar"), lrn("classif.featureless"), rsmp("holdout"))
rr$aggregate(msr("ci", "classif.acc"))
# is the same as:
rr$aggregate(msr("ci.holdout", "classif.acc"))
}
\section{Super classes}{
\code{\link[mlr3:Measure]{mlr3::Measure}} -> \code{\link[mlr3inferr:MeasureAbstractCi]{mlr3inferr::MeasureAbstractCi}} -> \code{Measure}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Measure-new}{\code{MeasureCi$new()}}
\item \href{#method-Measure-aggregate}{\code{MeasureCi$aggregate()}}
\item \href{#method-Measure-clone}{\code{MeasureCi$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="format"><a href='../../mlr3/html/Measure.html#method-Measure-format'><code>mlr3::Measure$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="help"><a href='../../mlr3/html/Measure.html#method-Measure-help'><code>mlr3::Measure$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="print"><a href='../../mlr3/html/Measure.html#method-Measure-print'><code>mlr3::Measure$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3" data-topic="Measure" data-id="score"><a href='../../mlr3/html/Measure.html#method-Measure-score'><code>mlr3::Measure$score()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-new"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCi$new(measure)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measure}}{(\code{\link[mlr3:Measure]{Measure}} or \code{character(1)})\cr
A measure of ID of a measure.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-aggregate"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-aggregate}{}}}
\subsection{Method \code{aggregate()}}{
Obtain a point estimate, as well as lower and upper CI boundary.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCi$aggregate(rr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rr}}{(\code{\link[mlr3:ResampleResult]{ResampleResult}})\cr
Resample result.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named \code{numeric(3)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Measure-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Measure-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MeasureCi$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
