% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlr_reflections.R
\docType{data}
\name{mlr_reflections}
\alias{mlr_reflections}
\title{Reflections for mlr3}
\format{
\link{environment}.
}
\usage{
mlr_reflections
}
\description{
Environment which stores various information to allow objects to examine and introspect their structure and properties
(c.f. \href{https://en.wikipedia.org/wiki/Reflective_programming}{Reflections}).

This environment be modified by third-party packages, e.g. by adding information about new task types
or by extending the set of allowed feature types.

Third-party packages that modify the reflections must register themselves in the \code{loaded_packages} field.

The following objects are set by \CRANpkg{mlr3}:
\itemize{
\item \code{task_types} (\code{data.table()})\cr
Table with task type (\code{"type"}), the implementing package (\code{"pkg"}), and the names of the generators
of the corresponding \link{Task} (\code{"task"}), \link{Learner} (\code{"learner"}),
\link{Prediction} (\code{"prediction"}), \link{Measure} (\code{"measure"}) and fallback \link{Learner}.
The column \code{"type"} must be unique for each row.
\item \code{task_feature_types} (named \code{character()})\cr
Vector of base R types supported as \link{Task} features, named with a 3 letter abbreviation.
\item \code{task_row_roles} (\code{character()})\cr
Vector of supported row roles for a \link{Task}.
\item \code{task_col_roles} (list of \code{character()})\cr
List of vectors of supported column roles for a \link{Task}, named by their task type.
\item \code{task_properties} (list of \code{character()})\cr
List of vectors of supported \link{Task} properties, named by their task type.
\item \code{task_mandatory_properties} (list of \code{character()})\cr
List of vectors of \link{Task} properties which necessarily must be supported by the \link{Learner}.
I.e., if the task property is not found in the set of the learner properties, an exception
is raised.
\item \code{task_print_col_roles} (list of named \code{character()})\cr
Vector of column roles to print via \code{print(task)} if the role is not empty, either
before or after the task's target, properties and features.
The names of the column roles are the values, the names correspond to the labels to use in the printer.
\item \code{learner_properties} (list of \code{character()})\cr
List of vectors of supported \link{Learner} properties, named by their task type.
\item \code{learner_predict_types} (list of list of \code{character()})\cr
List of lists of supported \link{Learner} predict_types, named by their task type.
The inner list translates the \code{"predict_type"} to all predict types returned, e.g.
predict type \code{"prob"} for a \link{LearnerClassif} provides the probabilities as well as the predicted labels, therefore \code{"prob"} maps to \code{c("response", "prob")}.
\item \code{learner_predict_types} (list of list of \code{character()})\cr
List of lists of supported \link{Learner} predict_types, named by their task type.
\item \code{learner_param_tags} (\code{character()})\cr
Character vector of allowed 'tags' for the \link[paradox:ParamSet]{paradox::ParamSet}s of a \link{Learner}.
\item \code{predict_sets} (\code{character()})\cr
Vector of possible predict sets. Currently supported are \code{"train"}, \code{"test"} and \code{"holdout"}.
\item \code{measure_properties} (list of \code{character()})\cr
List of vectors of supported \link{Measure} properties, named by their task type.
\item \code{default_measures} (list of \code{character()})\cr
List of keys for the default \link{Measure}s, named by their task type.
\item \code{rr_names} (\code{character()})\cr
Names of the objects stored in a \link{ResampleResult}.
\item \code{auto_converters} (\code{environment()})\cr
Environment of converter functions used for \code{rbind}-ing data to tasks.
Functions are named using the pattern \code{"[from_type]___[to_type]"}.
Can be extended by third-party with additional converters.
}
}
\examples{
ls.str(mlr_reflections)
}
\keyword{internal}
