% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CallbackResample.R
\name{callback_resample}
\alias{callback_resample}
\title{Create Evaluation Callback}
\usage{
callback_resample(
  id,
  label = NA_character_,
  man = NA_character_,
  on_resample_begin = NULL,
  on_resample_before_train = NULL,
  on_resample_before_predict = NULL,
  on_resample_end = NULL
)
}
\arguments{
\item{id}{(\code{character(1)})\cr
Identifier for the new instance.}

\item{label}{(\code{character(1)})\cr
Label for the new instance.}

\item{man}{(\code{character(1)})\cr
String in the format \verb{[pkg]::[topic]} pointing to a manual page for this object.
The referenced help package can be opened via method \verb{$help()}.}

\item{on_resample_begin}{(\verb{function()})\cr
Stage called at the beginning of an evaluation.
Called in \code{workhorse()} (internal).}

\item{on_resample_before_train}{(\verb{function()})\cr
Stage called before training the learner.
Called in \code{workhorse()} (internal).}

\item{on_resample_before_predict}{(\verb{function()})\cr
Stage called before predicting.
Called in \code{workhorse()} (internal).}

\item{on_resample_end}{(\verb{function()})\cr
Stage called at the end of an evaluation.
Called in \code{workhorse()} (internal).}
}
\description{
Function to create a \link{CallbackResample}.
Predefined callbacks are stored in the \link[mlr3misc:Dictionary]{dictionary} \link{mlr_callbacks} and can be retrieved with \code{\link[=clbk]{clbk()}}.

Evaluation callbacks are called at different stages of the resampling process.
Each stage is called once per resampling iteration.
The stages are prefixed with \verb{on_resample_*}.
The text in brackets indicates what happens between the stages in the internal \code{workhorse()} function and which accesses to the \link{ContextResample} (\code{ctx}) are typical for the stage.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Start Resampling Iteration on Worker
 - on_resample_begin
   (Split `ctx$task` into training and test set with `ctx$resampling` and `ctx$iteration`)
 - on_resample_before_train
   (Train the learner `ctx$learner` on training data)
 - on_resample_before_predict
   (Predict on predict sets and store prediction data `ctx$pdatas`)
 - on_resample_end
   (Erase model `ctx$learner$model` if requested and return results)
End Resampling Iteration on Worker
}\if{html}{\out{</div>}}

The callback can store data in \code{ctx$learner$state} or \code{ctx$data_extra}.
The data in \code{ctx$data_extra} is stored in the \link{ResampleResult} or \link{BenchmarkResult}.
See also the section on parameters for more information on the stages.
}
\details{
When implementing a callback, each function must have two arguments named \code{callback} and \code{context}.
A callback can write data to the state (\verb{$state}), e.g. settings that affect the callback itself.
We highly discourage changing the task, learner and resampling objects via the callback.
}
\examples{
learner = lrn("classif.rpart")
task = tsk("pima")
resampling = rsmp("cv", folds = 3)

# save selected features callback
callback = callback_resample("selected_features",
 on_resample_end = function(callback, context) {
    context$learner$state$selected_features = context$learner$selected_features()
  }
)

rr = resample(task, learner, resampling, callbacks = callback)
rr$learners[[1]]$state$selected_features

# holdout task callback
callback = callback_resample("holdout_task",
  on_resample_before_predict = function(callback, context) {
    pred = context$learner$predict(callback$state$task)
    context$data_extra = list(prediction_holdout = pred)
  }
)

task_holdout = tsk("pima")
splits = partition(task, 0.7)
task$filter(splits$train)
task_holdout$filter(splits$test)

callback$state$task = task_holdout

rr = resample(task, learner, resampling, callbacks = callback)
rr$data_extra
}
