/**
 * @file src/lars.cpp
 *
 * This is an autogenerated file containing implementations of C++ functions to
 * be called by the R lars binding.
 */
#include <rcpp_mlpack.h>
#define BINDING_TYPE BINDING_TYPE_R
#include <mlpack/methods/lars/lars_main.cpp>

#define Realloc(p,n,t) (t *) R_chk_realloc( (void *)(p), (R_SIZE_T)((n) * sizeof(t)) )
#define Free(p)        (R_chk_free( (void *)(p) ), (p) = NULL)

// [[Rcpp::export]]
void lars_call(SEXP params, SEXP timers)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  util::Timers& t = *Rcpp::as<Rcpp::XPtr<util::Timers>>(timers);

  if (p.Has("verbose"))
    Log::Info.ignoreInput = false;
  else
    Log::Info.ignoreInput = true;

  BINDING_FUNCTION(p, t);
}

// Any implementations of methods for dealing with model pointers will be put
// below this comment, if needed.

// Get the pointer to a LARS<> parameter.
// [[Rcpp::export]]
SEXP GetParamLARSPtr(SEXP params,
                                   const std::string& paramName,
                                   SEXP inputModels)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  Rcpp::List inputModelsList(inputModels);
  LARS<>* modelPtr = p.Get<LARS<>*>(paramName);
  for (int i = 0; i < inputModelsList.length(); ++i)
  {
    Rcpp::XPtr<LARS<>> inputModel =
        Rcpp::as<Rcpp::XPtr<LARS<>>>(inputModelsList[i]);
    // Don't create a new XPtr---just reuse the one given as input, so that we
    // don't end up deleting it twice.
    if (inputModel.get() == modelPtr)
      return inputModel;
  }

  return std::move((Rcpp::XPtr<LARS<>>) p.Get<LARS<>*>(paramName));
}

// Set the pointer to a LARS<> parameter.
// [[Rcpp::export]]
void SetParamLARSPtr(SEXP params, const std::string& paramName, SEXP ptr)
{
  util::Params& p = *Rcpp::as<Rcpp::XPtr<util::Params>>(params);
  p.Get<LARS<>*>(paramName) = Rcpp::as<Rcpp::XPtr<LARS<>>>(ptr);
  p.SetPassed(paramName);
}

// Serialize a LARS<> pointer.
// [[Rcpp::export]]
Rcpp::RawVector SerializeLARSPtr(SEXP ptr)
{
  std::ostringstream oss;
  {
    cereal::BinaryOutputArchive oa(oss);
    oa(cereal::make_nvp("LARS",
          *Rcpp::as<Rcpp::XPtr<LARS<>>>(ptr)));
  }

  Rcpp::RawVector raw_vec(oss.str().size());

  // Copy the string buffer so we can return one that won't get deallocated when
  // we exit this function.
  memcpy(&raw_vec[0], oss.str().c_str(), oss.str().size());
  raw_vec.attr("type") = "LARS";
  return raw_vec;
}

// Deserialize a LARS<> pointer.
// [[Rcpp::export]]
SEXP DeserializeLARSPtr(Rcpp::RawVector str)
{
  LARS<>* ptr = new LARS<>();

  std::istringstream iss(std::string((char *) &str[0], str.size()));
  {
    cereal::BinaryInputArchive ia(iss);
    ia(cereal::make_nvp("LARS", *ptr));
  }

  // R will be responsible for freeing this.
  return std::move((Rcpp::XPtr<LARS<>>)ptr);
}


