% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tracking-experiments.R
\name{mlflow_search_experiments}
\alias{mlflow_search_experiments}
\title{Search Experiments}
\usage{
mlflow_search_experiments(
  filter = NULL,
  experiment_view_type = c("ACTIVE_ONLY", "DELETED_ONLY", "ALL"),
  max_results = 1000,
  order_by = list(),
  page_token = NULL,
  client = NULL
)
}
\arguments{
\item{filter}{A filter expression used to identify specific experiments.
The syntax is a subset of SQL which allows only ANDing together binary operations.
Examples: "attribute.name = 'MyExperiment'", "tags.problem_type = 'iris_regression'"}

\item{experiment_view_type}{Experiment view type. Only experiments matching this view type are
returned.}

\item{max_results}{Maximum number of experiments to retrieve.}

\item{order_by}{List of properties to order by. Example: "attribute.name".}

\item{page_token}{Pagination token to go to the next page based on a
previous query.}

\item{client}{(Optional) An MLflow client object returned from \link[mlflow]{mlflow_client}.
If specified, MLflow will use the tracking server associated with the passed-in client. If
unspecified (the common case),
MLflow will use the tracking server associated with the current tracking URI.}
}
\description{
Search for experiments that satisfy specified criteria.
}
