% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchical_kinetics.R
\name{hierarchical_kinetics}
\alias{hierarchical_kinetics}
\title{Hierarchical kinetics template}
\usage{
hierarchical_kinetics(..., keep_tex = FALSE)
}
\arguments{
\item{...}{Arguments to \code{rmarkdown::pdf_document}}

\item{keep_tex}{Keep the intermediate tex file used in the conversion to PDF.
Note that this argument does not control whether to keep the auxiliary
files (e.g., \file{.aux}) generated by LaTeX when compiling \file{.tex} to
\file{.pdf}. To keep these files, you may set \code{options(tinytex.clean =
FALSE)}.}
}
\value{
R Markdown output format to pass to
\code{\link[rmarkdown:render]{render}}
}
\description{
R markdown format for setting up hierarchical kinetics based on a template
provided with the mkin package. This format is based on \link[rmarkdown:pdf_document]{rmarkdown::pdf_document}.
Chunk options are adapted. Echoing R code from code chunks and caching are
turned on per default. character for prepending output from code chunks is
set to the empty string, code tidying is off, figure alignment defaults to
centering, and positioning of figures is set to "H", which means that
figures will not move around in the document, but stay where the user
includes them.
}
\details{
The latter feature (positioning the figures with "H") depends on the LaTeX
package 'float'. In addition, the LaTeX package 'listing' is used in the
template for showing model fit summaries in the Appendix. This means that
the LaTeX packages 'float' and 'listing' need to be installed in the TeX
distribution used.

On Windows, the easiest way to achieve this (if no TeX distribution
is present before) is to install the 'tinytex' R package, to run
'tinytex::install_tinytex()' to get the basic tiny Tex distribution,
and then to run 'tinytex::tlmgr_install(c("float", "listing"))'.
}
\examples{

\dontrun{
library(rmarkdown)
# The following is now commented out after the relase of v1.2.3 for the generation
# of online docs, as the command creates a directory and opens an editor
#draft("example_analysis.rmd", template = "hierarchical_kinetics", package = "mkin")
}

}
