% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.data.R
\name{read.data}
\alias{read.data}
\title{Read Data File in Table format, SPSS, Excel, or Stata DTA File}
\usage{
read.data(file, sheet = NULL, header = TRUE, select = NULL, drop = NULL,
          sep = "auto", dec = "auto", use.value.labels = FALSE,
          use.missings = TRUE, na.strings = c("NA", ""),
          stringsAsFactors = FALSE, formats = FALSE, label = FALSE,
          labels = FALSE, missing = FALSE, widths = FALSE, as.data.frame = TRUE,
          encoding = c("unknown", "UTF-8", "Latin-1"), check = TRUE)
}
\arguments{
\item{file}{a character string indicating the name of the data file
with the file extension \code{.csv}, \code{.dat},
\code{.txt}, \code{.sav}, \code{.xlsx}, or \code{.dta}.
Note that the function will select an appropriate
\code{read}-function depending on the file extension.}

\item{sheet}{a character string indicating the name of a Excel sheet
or a numeric value indicating the position of the Excel
sheet to read. By default the first sheet will be read
when reading an Excel file (\code{.xlsx}).}

\item{header}{logical: if \code{TRUE} (default), the first row is used
as column names when reading an Excel file (\code{.xlsx}),
if \code{FALSE} default names are used. A character vector
giving a name for each column can also be used.}

\item{select}{a character vector of column names or numeric vector to
keep, drop the rest. See the help page of the
\code{fread} function in the \pkg{data.table} package.}

\item{drop}{a character vector of column names or numeric vector
to drop, keep the rest.}

\item{sep}{a character string indicating the separator between
columns for the \code{fread} function when reading data
in CSV (\code{.csv}), DAT (\code{.dat}), or TXT (\code{.txt})
format.}

\item{dec}{a character string indicating the decimal separator
for the \code{fread} function when reading data in CSV
(\code{.csv}), DAT (\code{.dat}), or TXT (\code{.txt})
format.}

\item{use.value.labels}{logical: if \code{TRUE}, variables with value labels
are converted into factors.}

\item{use.missings}{logical: if \code{TRUE} (default), user-defined missing
values are converted into NAs.}

\item{na.strings}{a character vector of strings which are to be interpreted
as NA values.}

\item{stringsAsFactors}{logical: if \code{TRUE}, character vectors are converted
to factors.}

\item{formats}{logical: if \code{TRUE}, variable formats are shown in
an attribute for all variables.}

\item{label}{logical: if \code{TRUE}, variable labels are shown in
an attribute for all variables.}

\item{labels}{logical: if \code{TRUE}, value labels are shown in an
attribute for all variables.}

\item{missing}{logical: if \code{TRUE}, value labels for user-defined
missings are shown in an attribute for all variables.}

\item{widths}{logical: if \code{TRUE}, widths are shown in an attribute
for all variables.}

\item{as.data.frame}{logical: if \code{TRUE} (default), function returns a
regular data frame; if \code{FALSE} function returns
a tibble or data.table.}

\item{encoding}{a character string indicating the encoding, i.e.,
\code{"unknown"}, \code{"UTF-8"}, or \code{"Latin-1"}
(default).}

\item{check}{logical: if \code{TRUE} (default), argument specification
is checked.}
}
\value{
Returns a data frame, tibble, or data table.
}
\description{
This function reads a (1) data file in CSV (\code{.csv}), DAT (\code{.dat}),
or TXT (\code{.txt}) format using the \code{fread} function from the \pkg{data.table}
package, (2) SPSS file (\code{.sav}) using the \code{read.sav} function, (3)
Excel file (\code{.xlsx}) using the \code{read.xlsx} function, or a (4) Stata
DTA file (\code{.dta}) using the \code{read.dta} function in the \pkg{misty}
package.
}
\examples{
\dontrun{

# Read CSV data file
dat <- read.data("CSV_Data.csv")

# Read DAT data file
dat <- read.data("DAT_Data.dat")

# Read TXT data file
dat <- read.data("TXT_Data.txt")

# Read SPSS data file
dat <- read.data("SPSS_Data.sav")

# Read Excel data file
dat <- read.data("Excel_Data.xlsx")

# Read Stata data file
dat <- read.data("Stata_Data.dta")
}
}
\references{
Barrett, T., Dowle, M., Srinivasan, A., Gorecki, J., Chirico, M., Hocking, T.,
& Schwendinger, B. (2024). data.table: Extension of 'data.frame'. R package
version 1.16.0. \url{https://CRAN.R-project.org/package=data.table}

Wickham H, Miller E, Smith D (2023). \emph{haven: Import and Export 'SPSS',
'Stata' and 'SAS' Files}. R package version 2.5.3.
\url{https://CRAN.R-project.org/package=haven}
}
\seealso{
\code{\link{read.sav}}, \code{\link{read.xlsx}}, \code{\link{read.dta}},
\code{\link{read.mplus}}
}
\author{
Takuya Yanagida
}
