% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misha-package.R
\docType{package}
\name{misha-package}
\alias{misha-package}
\alias{misha}
\title{Toolkit for analysis of genomic data}
\description{
'misha' package is intended to help users to efficiently analyze genomic
data achieved from various experiments.
}
\details{
For a complete list of help resources, use \code{library(help = "misha")}.

The following options are available for the package. Use 'options' function
to alter the value of the options.

\tabular{lll}{ NAME \tab DEFAULT \tab DESCRIPTION \cr gmax.data.size \tab
AUTO \tab Auto-configured based on system RAM and processes. \cr \tab \tab
Formula: min((RAM * 0.7) / gmax.processes, 10GB). \cr \tab \tab Controls
max in-memory result buffer size for streaming/sampling. \cr \tab \tab
Operations like gextract, gscreen use this as upper bound. \cr gbig.intervals.size
\tab 1000000 \tab Threshold for converting interval sets to disk-based \cr \tab \tab
"big" format. When interval count exceeds this, intervals \cr \tab \tab
are stored per-chromosome instead of all in memory. \cr \tab \tab
Note: Independent of gmax.data.size (different purposes). \cr gmax.mem.usage
\tab 10000000 \tab Maximal memory consumption of all child \cr \tab \tab
processes in KB before the limiting algorithm is invoked. \cr
gmax.processes \tab AUTO \tab Auto-configured to 70\% of CPU cores. \cr \tab
\tab Maximal number of processes for multitasking. \cr gmax.processes2core
\tab 2 \tab Maximal number of processes per CPU core for multitasking \cr
gmin.scope4process \tab 10000 \tab Minimal scope range (for 2D: surface)
assigned to a process \cr \tab \tab in multitasking mode. \cr gbuf.size \tab
1000 \tab Size of track expression values buffer. \cr
gmultitask.max.records.factor \tab 64 \tab Multiplier to inflate multitask
\cr \tab \tab max_records estimates to avoid under-allocation. \cr
gtrack.chunk.size \tab
100000 \tab Chunk size in bytes of a 2D track. If '0' chunk size \cr \tab \tab
is unlimited. \cr gtrack.num.chunks \tab 0 \tab Maximal number of 2D track
chunks simultaneously stored \cr \tab \tab in memory. \cr gmultitasking \tab
TRUE \tab Enable/disable automatic parallelization. Some functions \cr \tab
\tab may choose single-threaded mode for very small workloads. \cr }

More information about the options can be found in 'User manual' of the
package.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://tanaylab.github.io/misha/}
  \item \url{https://github.com/tanaylab/misha}
  \item Report bugs at \url{https://github.com/tanaylab/misha/issues}
}

}
\author{
\strong{Maintainer}: Aviezer Lifshitz \email{aviezer.lifshitz@weizmann.ac.il}

Authors:
\itemize{
  \item Misha Hoichman \email{misha@hoichman.com}
  \item Eitan Yaffe \email{eitan.yaffe@weizmann.ac.il}
  \item Amos Tanay \email{amos.tanay@weizmann.ac.il}
}

Other contributors:
\itemize{
  \item Weizmann Institute of Science [copyright holder]
}

}
\keyword{package}
