% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synth.R
\name{gsynth.replace_kmer}
\alias{gsynth.replace_kmer}
\title{Iteratively replace a k-mer in the genome}
\usage{
gsynth.replace_kmer(
  target,
  replacement,
  output_path = NULL,
  output_format = c("misha", "fasta", "vector"),
  intervals = NULL,
  check_composition = TRUE
)
}
\arguments{
\item{target}{The k-mer sequence to remove (e.g., "CG").}

\item{replacement}{The replacement sequence (e.g., "GC").}

\item{output_path}{Path to the output file (ignored when output_format = "vector").}

\item{output_format}{Output format:
\itemize{
  \item "misha": .seq binary format (default)
  \item "fasta": FASTA text format
  \item "vector": Return sequences as a character vector (does not write to file)
}}

\item{intervals}{Genomic intervals to process. If NULL, uses all chromosomes.}

\item{check_composition}{Logical. If TRUE (default), ensures target and
replacement have the same nucleotide composition (preserving exact
base counts).}
}
\value{
When output_format is "misha" or "fasta", returns invisible NULL and
        writes to output_path. When output_format is "vector", returns a
        character vector of modified sequences.
}
\description{
Performs an iterative replacement of a \code{target} k-mer with a
\code{replacement} sequence. This is useful for creating synthetic genomes
with specific motifs removed (e.g., creating a CpG-null genome by iteratively
swapping CG to GC).
}
\details{
\strong{Bubble Sort / Iterative Logic:} The function scans the sequence and
replaces occurrences of \code{target} with \code{replacement}. If a replacement
creates a new instance of \code{target} (e.g., removing "CG" with "GC" in
the sequence "CCG" -> "CGC"), the new instance is also replaced. This continues
until the sequence is free of the \code{target} k-mer.

When \code{target} and \code{replacement} are permutations of each other
(e.g., "CG" and "GC"), this acts as a "bubble sort" of nucleotides, moving
bases locally without altering the total GC content or base counts of the genome.
}
\examples{
\dontrun{
# Robust removal of all CpG dinucleotides (preserving GC\%)
gsynth.replace_kmer(
    target = "CG",
    replacement = "GC",
    output_path = "genome_no_cpg.seq",
    output_format = "misha"
)
}
}
