% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_mv.R
\name{mc_mv}
\alias{mc_mv}
\title{move or rename files or directories between servers}
\usage{
mc_mv(from, to, recursive = FALSE, flags = "", verbose = FALSE)
}
\arguments{
\item{from}{Character string specifying the source file or directory path.
Can accept a vector of file paths as well.}

\item{to}{Character string specifying the destination path.}

\item{recursive}{Logical indicating whether to recursively move directories.
Default is \code{FALSE}.}

\item{flags}{any additional flags to \code{mv}}

\item{verbose}{Logical indicating whether to report files copied.
Default is \code{FALSE}.}
}
\value{
Returns the list from \code{\link[processx:run]{processx::run()}}, with components \code{status},
\code{stdout}, \code{stderr}, and \code{timeout}; invisibly.
}
\description{
move or rename files or directories between servers
}
\details{
see \code{mc("mv -h")} for details.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# move a file
mc_mv("local/path/to/file.txt", "alias/bucket/path/file.txt")

# move a directory recursively
mc_mv("local/directory", "alias/bucket/path/to/directory", recursive = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
mc_cp
}
