% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create}
\alias{create}
\alias{create_empty}
\alias{create_complete}
\alias{create_ring}
\alias{create_components}
\alias{create_star}
\alias{create_tree}
\alias{create_lattice}
\title{Create networks with particular structures}
\usage{
create_empty(n)

create_complete(n)

create_ring(n, width = 1, directed = FALSE, ...)

create_components(n, components = 2)

create_star(n, direction = c("undirected", "in", "out"))

create_tree(n, direction = c("undirected", "in", "out"), branches = 2)

create_lattice(n, direction = c("undirected", "in", "out"))
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A migraph-compatible object,
a network of the same dimensions will be created.
}}

\item{width}{The width or breadth of the ring. This is typically double the degree.}

\item{directed}{Whether the graph should be directed. By default FALSE.}

\item{...}{Additional arguments passed on to igraph.}

\item{components}{Number of components to divide the nodes into.}

\item{direction}{One of the following options: "in", "out", or "undirected" (DEFAULT).}

\item{branches}{How many branches at each level.}
}
\value{
By default an igraph object will be returned,
but this can be coerced into other types of objects
using \code{as_matrix()}, \code{as_tidygraph()}, or \code{as_network()}.
}
\description{
These functions create networks with particular structural properties.
They can create either one-mode and two-mode networks,
depending on whether the common \code{n} argument
is passed a single integer (the number of nodes in the one-mode network)
or a vector of \emph{two} integers to return a two-mode network.
}
\section{Functions}{
\itemize{
\item \code{create_empty}: Creates an empty graph of the given dimensions.

\item \code{create_complete}: Creates a filled graph of the given dimensions,
with every possible tie realised.

\item \code{create_ring}: Creates a ring or chord graph of the given dimensions
that loops around is of a certain width or thickness.

\item \code{create_components}: Creates a graph in which the nodes are clustered
into separate components.

\item \code{create_star}: Creates a graph of the given dimensions that has a maximally central node

\item \code{create_tree}: Creates a graph of the given dimensions with successive branches.

\item \code{create_lattice}: Creates a graph of the given dimensions with ties to all neighbouring nodes
}}

\examples{
autographr(create_empty(c(8,6))) +
autographr(create_complete(c(8,6)))
autographr(create_ring(8, width = 2)) + 
autographr(create_ring(c(8,6), width = 2))
autographr(create_components(c(10, 12), components = 3))
autographr(create_star(12, "in")) +
autographr(create_star(12, "out")) +
autographr(create_star(c(12,1), "in"))
autographr(create_tree(15, direction = "out")) + 
autographr(create_tree(15, direction = "out"), "tree") + 
autographr(create_tree(15, direction = "out", branches = 3), "tree")
autographr(create_lattice(5), layout = "kk") +
autographr(create_lattice(c(5,5))) +
autographr(create_lattice(c(5,5,5)))
}
\seealso{
as_matrix as_tidygraph as_network

Other creation: 
\code{\link{generate}}
}
\concept{creation}
