% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohesion.R
\name{cohesion}
\alias{cohesion}
\alias{graph_density}
\alias{edge_reciprocal}
\alias{graph_reciprocity}
\alias{graph_transitivity}
\alias{graph_equivalency}
\alias{graph_congruency}
\alias{edge_multiple}
\alias{edge_loop}
\title{Cohesion for one-, two-, and three- mode networks}
\usage{
graph_density(object)

edge_reciprocal(object)

graph_reciprocity(object, method = "default")

graph_transitivity(object)

graph_equivalency(object)

graph_congruency(object, object2)

edge_multiple(object)

edge_loop(object)
}
\arguments{
\item{object}{A one-mode or two-mode matrix, igraph, or tidygraph}

\item{method}{For reciprocity, either \code{default} or \code{ratio}.
See \code{?igraph::reciprocity}}

\item{object2}{Optionally, a second (two-mode) matrix, igraph, or tidygraph}
}
\description{
These functions offer methods for summarising the cohesion in one-, two-, and three-mode networks.
}
\details{
For one- and two-mode networks, \code{graph_density} summarises the ratio of ties
to the number of possible ties.

For one-mode networks, shallow wrappers of igraph versions exist via
\code{graph_reciprocity} and \code{graph_transitivity}.

For two-mode networks, \code{graph_equivalency} calculates the proportion of three-paths in the network
that are closed by fourth tie to establish a "shared four-cycle" structure.

For three-mode networks, \code{graph_congruency} calculates the proportion of three-paths spanning the two two-mode networks
that are closed by a fourth tie to establish a "congruent four-cycle" structure.
}
\section{Functions}{
\itemize{
\item \code{edge_reciprocal}: Identify edges that are mutual/reciprocated

\item \code{graph_reciprocity}: Calculate reciprocity in a network

\item \code{graph_transitivity}: Calculate transitivity in a network

\item \code{graph_equivalency}: Calculate equivalence or reinforcement in a network

\item \code{graph_congruency}: Calculate congruency in a network

\item \code{edge_multiple}: Identify edges that are multiples

\item \code{edge_loop}: Identify edges that are loops
}}

\examples{
graph_density(mpn_elite_mex)
graph_density(mpn_elite_usa_advice)
edge_reciprocal(ison_algebra)
graph_reciprocity(ison_southern_women)
graph_transitivity(ison_southern_women)
graph_equivalency(ison_southern_women)
edge_multiple(ison_algebra)
edge_loop(ison_algebra)
}
\references{
Robins, Garry L, and Malcolm Alexander. 2004.
Small worlds among interlocking directors: Network structure and distance in bipartite graphs.
\emph{Computational & Mathematical Organization Theory} 10 (1): 69–94.

Knoke, David, Mario Diani, James Hollway, and Dimitris C Christopoulos. 2021.
\href{https://www.cambridge.org/core/books/multimodal-political-networks/43EE8C192A1B0DCD65B4D9B9A7842128}{\emph{Multimodal Political Networks}}.
Cambridge University Press. Cambridge University Press.
}
\seealso{
Other one-mode measures: 
\code{\link{node_constraint}()}

Other two-mode measures: 
\code{\link{graph_smallworld}()},
\code{\link{node_constraint}()}
}
\concept{one-mode measures}
\concept{three-mode measures}
\concept{two-mode measures}
