% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smallworld.R
\name{node_smallworld}
\alias{node_smallworld}
\title{Watts-Strogatz small-world model for two-mode networks}
\usage{
node_smallworld(object, n = 100)
}
\arguments{
\item{object}{A matrix, igraph graph, or tidygraph object}

\item{n}{Number of simulations}
}
\value{
Returns a table of small-world related metrics for each second-mode
node.
}
\description{
Calculates small-world metrics for two-mode networks
}
\details{
The first column of the returned table is simply the number of
the second-mode column. The next three columns report the observed and
expected clustering, and the ratio of the former to the later.
The next three columns report the observed and expected path-length,
and the ratio of the former to the later.
The last column reports the ratio of the observed/expected clustering ratio
to the observed/expected path-length ratio, which is known as a small-world
metric.
Expected clustering and paths is the mean of twomode_clustering and
mean_distance over 100 random simulations with the same row and column sums.
}
\examples{
node_smallworld(southern_women)
}
\seealso{
\code{\link{graph_transitivity}} and \code{\link{graph_equivalency}}
for how clustering is calculated

Other two-mode measures: 
\code{\link{centrality}},
\code{\link{centralization}},
\code{\link{cohesion}},
\code{\link{node_constraint}()}

Other node-level measures: 
\code{\link{centrality}},
\code{\link{node_constraint}()}
}
\concept{node-level measures}
\concept{two-mode measures}
