% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure_centrality.R
\name{tie_centrality}
\alias{tie_centrality}
\alias{tie_degree}
\alias{tie_closeness}
\alias{tie_betweenness}
\alias{tie_eigenvector}
\title{Measures of tie centrality}
\usage{
tie_degree(object, normalized = TRUE)

tie_closeness(object, normalized = TRUE)

tie_betweenness(object, normalized = TRUE)

tie_eigenvector(object, normalized = TRUE)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}

\item{normalized}{Logical scalar, whether the centrality scores are normalized.
Different denominators are used depending on whether the object is one-mode or two-mode,
the type of centrality, and other arguments.}
}
\description{
Measures of tie centrality
}
\section{Functions}{
\itemize{
\item \code{tie_degree()}: Calculate the degree centrality of edges in a network

\item \code{tie_closeness()}: Calculate the closeness of each edge to each other edge
in the network.

\item \code{tie_betweenness()}: Calculate number of shortest paths going through an edge

\item \code{tie_eigenvector()}: Calculate the eigenvector centrality of edges in a network

}}
\examples{
tie_degree(ison_adolescents)
(ec <- tie_closeness(ison_adolescents))
plot(ec)
ison_adolescents \%>\% 
  activate(edges) \%>\% mutate(weight = ec) \%>\% 
  autographr()
(tb <- tie_betweenness(ison_adolescents))
plot(tb)
ison_adolescents \%>\% 
  activate(edges) \%>\% mutate(weight = tb) \%>\% 
  autographr()
tie_eigenvector(ison_adolescents)
}
\seealso{
Other measures: 
\code{\link{centralisation}},
\code{\link{centrality}},
\code{\link{closure}},
\code{\link{cohesion}()},
\code{\link{diversity}},
\code{\link{features}},
\code{\link{holes}}
}
\concept{measures}
