% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_generate.R
\name{generate}
\alias{generate}
\alias{generate_random}
\alias{generate_smallworld}
\alias{generate_scalefree}
\alias{generate_permutation}
\title{Make networks with a stochastic element}
\usage{
generate_random(n, p = 0.5, directed = FALSE, with_attr = TRUE)

generate_smallworld(n, p = 0.05, width = 2, directed = FALSE)

generate_scalefree(n, p = 1, directed = FALSE)

generate_permutation(object, with_attr = TRUE)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A migraph-compatible object,
a network of the same dimensions will be created.
}}

\item{p}{Proportion of possible ties in the network that are realised or,
if integer greater than 1, the number of ties in the network.}

\item{directed}{Whether to generate network as directed. By default FALSE.}

\item{with_attr}{Logical whether any attributes of the object
should be retained.
By default TRUE.}

\item{width}{Integer specifying the width or breadth
of the ring or branches.}

\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix (adjacency or incidence) from \code{{base}} R
\item edgelist, a data frame from \code{{base}} R or tibble from \code{{tibble}}
\item igraph, from the \code{{igraph}} package
\item network, from the \code{{network}} package
\item tbl_graph, from the \code{{tidygraph}} package
}}
}
\value{
By default an \code{igraph} object is returned,
but this can be coerced into other types of objects
using \code{as_matrix()}, \code{as_tidygraph()}, or \code{as_network()}.
}
\description{
These functions are similar to the \verb{create_*} functions,
but include some element of randomisation.
They are particularly useful for creating a distribution of networks
for exploring or testing network properties.
}
\section{Functions}{
\itemize{
\item \code{generate_random}: Generates a random network with a particular probability.

\item \code{generate_smallworld}: Generates a small-world structure
following the lattice rewiring model.

\item \code{generate_scalefree}: Generates a scale-free structure
following the preferential attachment model.

\item \code{generate_permutation}: Generates a permutation of the original network
using a Fisher-Yates shuffle on both the rows and columns (for a one-mode network)
or on each of the rows and columns (for a two-mode network).
}}

\examples{
autographr(generate_random(12, 0.4)) +
autographr(generate_random(c(6, 6), 0.4))
autographr(generate_smallworld(12, 0.025)) +
autographr(generate_smallworld(12, 0.25)) +
autographr(generate_smallworld(c(6,6), 0.025))
autographr(generate_scalefree(12, 0.25)) +
autographr(generate_scalefree(12, 1.25))
autographr(generate_scalefree(c(12,6), 0.25)) /
autographr(generate_scalefree(c(12,6), 1.25))
autographr(mpn_elite_usa_advice) +
autographr(generate_permutation(mpn_elite_usa_advice))
}
\references{
Erdős, Paul, and Alfréd Rényi. (1959).
"\href{https://www.renyi.hu/~p_erdos/1959-11.pdf}{On Random Graphs I}"
\emph{Publicationes Mathematicae}. 6: 290–297.

Watts, Duncan J., and Steven H. Strogatz. 1998.
“Collective Dynamics of ‘Small-World’ Networks.”
\emph{Nature} 393(6684):440–42.
\doi{10.1038/30918}.

Barabási, Albert-László, and Réka Albert. 1999.
“Emergence of Scaling in Random Networks.”
\emph{Science} 286(5439):509–12.
\doi{10.1126/science.286.5439.509}.
}
\seealso{
\link{as}

Other makes: 
\code{\link{create}},
\code{\link{read}}
}
\concept{makes}
