% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffs_rates.R
\name{ffs_rates}
\alias{ffs_rates}
\title{Estimation of bilateral migrant flows from bilateral migrant stocks using rates approaches}
\usage{
ffs_rates(stock_start = NULL, stock_end = NULL, M = NULL, method = "dennett")
}
\arguments{
\item{stock_start}{Matrix of migrant stock totals at time \emph{t}. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}}

\item{stock_end}{Matrix of migrant stock totals at time \emph{t}+1. Rows in the matrix correspond to place of birth and columns to place of residence at time \emph{t}+1.}

\item{M}{Numeric value for the global sum of migration flows, used for \code{dennett} approach.}

\item{method}{Method to estimate flows. Can take values \code{dennett} or \code{rogers-von-rabenau}. See details section for more information. Uses \code{dennett} as default.}
}
\value{
Estimates migrant transitions flows based on migration rates.

When \code{method = "dennett"} migration are derived from the matrix supplied to \code{stock_start}. Dennett uses bilateral migrant stocks at beginning of period. Rates then multiplied by global migration flows supplied in \code{M}.

When \code{method = "rogers-von-rabenau"} a matrix of growth rates are derived from the changes in initial populations stock \code{stock_start} to obtain \code{stock_end};
\deqn{P^{t+1} = g P^{t}}
and then multiplied by the corresponding populations at risk in \code{stock_start}. Can result in negative flows.
}
\description{
Estimates migrant transitions flows between two sequential migrant stock tables using approached based on rates.
}
\examples{
s1 <- matrix(data = c(100, 10, 10, 0, 20, 55, 25, 10, 10, 40, 140, 65, 20, 25, 20, 200),
             nrow = 4, ncol = 4, byrow = TRUE)
s2 <- matrix(data = c(75, 25, 5, 15, 20, 45, 30, 15, 30, 40, 150, 35, 10, 50, 5, 200),
             nrow = 4, ncol = 4, byrow = TRUE)
r <- LETTERS[1:4]
dimnames(s1) <- dimnames(s2) <- list(pob = r, por = r)
s1; s2

# calculate total migration flows for dennett approach
n <- colSums(s2) - colSums(s1)

ffs_rates(stock_start = s1, M =  sum(abs(n)), method = "dennett" )
ffs_rates(stock_start = s1, stock_end = s2, method = "rogers-von-rabenau" )
}
\references{
Dennett, A. (2015). Estimating an Annual Time Series of Global Migration Flows - An Alternative Methodology for Using Migrant Stock Data. \emph{Global Dynamics: Approaches from Complexity Science}, 125–142. https://doi.org/10.1002/9781118937464.ch7

Rogers, A., & Von Rabenau, B. (1971). Estimation of interregional migration streams from place-of-birth-by-residence data. \emph{Demography}, 8(2), 185–194.
}
\seealso{
\code{\link{ffs_demo}}, \code{\link{ffs_rates}}
}
\author{
Guy J. Abel
}
