% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micsr-package.R
\docType{package}
\name{micsr-package}
\alias{micsr-package}
\title{\strong{micsr} : Microeconometrics with R}
\description{
The micsr package is the companion package to the book
"Microeconometrics with R" (Chapman and Hall/CRC The R Series). It
includes function to estimate and to test models, miscellanous
tools and data sets:
}
\details{
\itemize{
\item functions to estimate models:
\itemize{
\item \code{binomreg}: binomial regression models, Rivers and Vuong (1988),
\item \code{bivprobit}: bivariate probit model
\item \code{clm}: constrained linear models,
\item \code{escount}: endogenous switching and selection model for count data, Terza (1998),
\item \code{expreg}: exponential conditional mean models, Mullahy (1997),
\item \code{loglm}: log-linear models,
\item \code{ordreg}: ordered regression models,
\item \code{poisreg}: poisson models,
\item \code{pscore}: matching, Dehejia and Wahba (2002),
\item \code{tobit1}: tobit-1 model, Tobin (1958), Smith and Blundel (1986), Powel (1986).
}
\item functions for statistical tests and diagnostic:
\itemize{
\item \code{cmtest}: conditional moment tests, Newey (1985), Tauchen (1985),
\item \code{ftest}: F statistic,
\item \code{hausman}: Hausman's test, Hausman (1978),
\item \code{ndvuong}: non-degenerate Vuong test, Vuong (1989), Shi (2015),
\item \code{rsq}: different flavors of R squared,
\item \code{sargan}: Sargan's test, Sargan (1958),
\item \code{scoretest}: score, or Lagrange multiplier test.
}
\item miscellanous tools
\itemize{
\item \code{gaze}: print a short summary of an object,
\item \code{dummy}: generate a set of dummy variables from a factor,
\item \code{newton}: Newton-Raphson optimization method, using the analytical gradient and hessian,
\item \code{mills}: compute the inverse mills ratio and its first two derivatives,
\item \code{stder}: extract the standard errors of a fitted model,
\item \code{npar}: extract the number of parameters in a fitted model.
}
\item data sets:
\itemize{
\item \code{apples}: Apple production, Ivaldi and al. (1996), constrained
linear model,
\item \code{birthwt}: Cigarette smoking and birth weigth, Mullahy
(1997), exponentional conditional mean regression model,
\item \code{charitable}: Intergenerational transmission of charitable
giving, Wilhem (2008), Tobit-1 model,
\item \code{cigmales}: Cigarettes consumption and smoking habits,
Mullahy (1997), exponentional conditional mean regression mdodel,
\item \code{drinks}: Physician advice on alcohol consumption, Kenkel and
Terza (2001), endogenous switching model for count data,
\item \code{ferediv}: Foreign exchange derivatives use by large US bank
holding companies, Adkins (2012), instrumental variable probit
model,
\item \code{fin_reform}: Political economy of financial reforms, Abiad and
Mody (2005), ordered regression model,
\item \code{housprod}: Household production, Kerkhofs and Kooreman (2003),
bivariate probit model,
\item \code{mode_choice}: Choice between car and transit, Horowitz (1993),
probit model,
\item \code{trade_protection}: Lobying and trade protection, Atschke and
Sherlund (2006), instrumental variable Tobit-1 model,
\item \code{trips}: Determinants of household trip taking, Terza (1998),
endogenous switching model for count data,
\item \code{turnout}: Turnout in Texas liquor referenda, Coate and Conlin
(2004), non-degenerate Vuong test,
\item \code{twa}: Temporary help jobs and permanent employment, Ichino,
Mealli and Nannicini (2008), matching.
}
\item vignettes:
\itemize{
\item charitable: Estimating the Tobit-1 model with the charitable
data set
\item escount: Endogenous switching or sample selection models for
count data
\item expreg: Exponentional conditional mean models with endogeneity
\item ndvvuong: Implementation of Shi's non-degeranate Vuong test
}
}

We tried to keep the sets of package on which \strong{micsr} depends on
as small as possible. \strong{micsr} depends on \strong{Formula},
\strong{generics}, \strong{Rdpack}, \strong{knitr}, \strong{sandwich} and on a subset
of the \strong{tidyverse} metapackage (\strong{ggplot2}, \strong{dplyr},
\strong{purrr}, \strong{tidyselect}, \strong{magrittr}, \strong{tibble}, \strong{rlang}). We
borrowed the gaussian quadrature function from the \strong{statmod}
package (Smyth and al., 2023), and the distribution function of
quadratic forms in normal variables from the \strong{CompQuadForm}
package (Duchesne and Lafaye, 2010).
}
\references{
\insertRef{ABIA:MODY:05}{micsr}

\insertRef{ADKI:12}{micsr}

\insertRef{COAT:CONL:04}{micsr}

\insertRef{DEHE:WAHB:02}{micsr}

\insertRef{DUCH:LAFA:10}{micsr}

\insertRef{HAUS:78}{micsr}

\insertRef{ICHI:MEAL:NANN:08}{micsr}

\insertRef{IVAL:LADO:OSSA:SIMI:96}{micsr}

\insertRef{KENK:TERZ:01}{micsr}

\insertRef{KERK:KOOR:03}{micsr}

\insertRef{MATS:SHER:06}{micsr}

\insertRef{MULL:97}{micsr}

\insertRef{NEWE:85}{micsr}

\insertRef{POWE:86}{micsr}

\insertRef{RIVE:VUON:88}{micsr}

\insertRef{SARG:58}{micsr}

\insertRef{SHI:15}{micsr}

\insertRef{SMIT:BLUN:86}{micsr}

\insertRef{SMYT:CHEN:23}{micsr}

\insertRef{TAUC:85}{micsr}

\insertRef{TERZ:98}{micsr}

\insertRef{TOBI:58}{micsr}

\insertRef{VUON:89}{micsr}

\insertRef{WILH:08}{micsr}
}
\keyword{package}
