% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_env.R
\name{trans_env}
\alias{trans_env}
\title{Create trans_env object for the analysis of the effects of environmental factors on communities.}
\description{
This class is a wrapper for a series of operations associated with environmental measurements, including redundancy analysis, 
mantel test and correlation analysis based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>.
}
\examples{

## ------------------------------------------------
## Method `trans_env$new`
## ------------------------------------------------

data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S)

## ------------------------------------------------
## Method `trans_env$cal_rda`
## ------------------------------------------------

\donttest{
t1$cal_rda(use_dbrda = TRUE, use_measure = "bray")
}

## ------------------------------------------------
## Method `trans_env$cal_rda_envsquare`
## ------------------------------------------------

\donttest{
t1$cal_rda_envsquare()
}

## ------------------------------------------------
## Method `trans_env$trans_rda`
## ------------------------------------------------

\donttest{
t1$trans_rda(adjust_arrow_length = TRUE, max_perc_env = 10)
}

## ------------------------------------------------
## Method `trans_env$plot_rda`
## ------------------------------------------------

\donttest{
t1$plot_rda(plot_color = "Group")
}

## ------------------------------------------------
## Method `trans_env$cal_mantel`
## ------------------------------------------------

\donttest{
t1$cal_mantel(use_measure = "bray")
}

## ------------------------------------------------
## Method `trans_env$cal_cor`
## ------------------------------------------------

\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_rf$Taxa[1:40])
}

## ------------------------------------------------
## Method `trans_env$plot_cor`
## ------------------------------------------------

\donttest{
t1$plot_cor(pheatmap = FALSE)
}

## ------------------------------------------------
## Method `trans_env$plot_scatterfit`
## ------------------------------------------------

\donttest{
t1$plot_scatterfit(x = 1, y = 2, alpha = .5)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_env$new()}}
\item \href{#method-cal_rda}{\code{trans_env$cal_rda()}}
\item \href{#method-cal_rda_envsquare}{\code{trans_env$cal_rda_envsquare()}}
\item \href{#method-trans_rda}{\code{trans_env$trans_rda()}}
\item \href{#method-plot_rda}{\code{trans_env$plot_rda()}}
\item \href{#method-cal_mantel}{\code{trans_env$cal_mantel()}}
\item \href{#method-cal_cor}{\code{trans_env$cal_cor()}}
\item \href{#method-plot_cor}{\code{trans_env$plot_cor()}}
\item \href{#method-plot_scatterfit}{\code{trans_env$plot_scatterfit()}}
\item \href{#method-print}{\code{trans_env$print()}}
\item \href{#method-clone}{\code{trans_env$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$new(
  dataset = NULL,
  env_cols = NULL,
  add_data = NULL,
  character2numeric = TRUE,
  complete_na = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{env_cols}}{default NULL; a vector to select columns in sample_table, when the environmental data is in sample_table. 
Either numeric vector or character vector of colnames.}

\item{\code{add_data}}{default NULL; data.frame format; provide the environmental data frame individually.}

\item{\code{character2numeric}}{default TRUE; whether transform the characters or factors to numeric attributes.}

\item{\code{complete_na}}{default FALSE; Whether fill the NA in the environmental data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
env_data in trans_env object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{data(dataset)
data(env_data_16S)
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_rda"></a>}}
\if{latex}{\out{\hypertarget{method-cal_rda}{}}}
\subsection{Method \code{cal_rda()}}{
Redundancy analysis (RDA) based on the rda function in vegan package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_rda(
  use_dbrda = TRUE,
  add_matrix = NULL,
  use_measure = NULL,
  feature_sel = FALSE,
  taxa_level = NULL,
  taxa_filter_thres = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_dbrda}}{default TRUE; whether use db-RDA, if FALSE, use RDA.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided, if you do not want to use the beta diversity matrix within the dataset.}

\item{\code{use_measure}}{default NULL; name of beta diversity matrix. If necessary and not provided, use the first beta diversity matrix.}

\item{\code{feature_sel}}{default FALSE; whether perform the feature selection.}

\item{\code{taxa_level}}{default NULL; If use RDA, provide the taxonomic rank.}

\item{\code{taxa_filter_thres}}{default NULL; If want to filter taxa, provide the relative abundance threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rda, res_rda_R2, res_rda_terms and res_rda_axis in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_rda(use_dbrda = TRUE, use_measure = "bray")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_rda_envsquare"></a>}}
\if{latex}{\out{\hypertarget{method-cal_rda_envsquare}{}}}
\subsection{Method \code{cal_rda_envsquare()}}{
Fits each environmental vector onto the RDA ordination to obtain the contribution of each variable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_rda_envsquare(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{the parameters passing to vegan::envfit function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rda_envsquare in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_rda_envsquare()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_rda"></a>}}
\if{latex}{\out{\hypertarget{method-trans_rda}{}}}
\subsection{Method \code{trans_rda()}}{
transform RDA result for the following plotting.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$trans_rda(
  show_taxa = 10,
  adjust_arrow_length = FALSE,
  min_perc_env = 1,
  max_perc_env = 100,
  min_perc_tax = 1,
  max_perc_tax = 100
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{show_taxa}}{default 10; taxa number shown in the plot.}

\item{\code{adjust_arrow_length}}{default FALSE; whether adjust the arrow length to be clear}

\item{\code{min_perc_env}}{default 1; minimum scale value for env arrow, relatively.}

\item{\code{max_perc_env}}{default 100; maximum scale value for env arrow, relatively.}

\item{\code{min_perc_tax}}{default 1; minimum scale value for tax arrow, relatively.}

\item{\code{max_perc_tax}}{default 100; maximum scale value for tax arrow, relatively.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_rda_trans in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$trans_rda(adjust_arrow_length = TRUE, max_perc_env = 10)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_rda"></a>}}
\if{latex}{\out{\hypertarget{method-plot_rda}{}}}
\subsection{Method \code{plot_rda()}}{
plot RDA result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_rda(
  plot_color = NULL,
  plot_shape = NULL,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  shape_values = c(16, 17, 7, 8, 15, 18, 11, 10, 12, 13, 9, 3, 4, 0, 1, 2, 14),
  taxa_text_color = "firebrick1",
  taxa_text_type = "italic"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{plot_color}}{default NULL; group used for color.}

\item{\code{plot_shape}}{default NULL; group used for shape.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); color pallete.}

\item{\code{shape_values}}{default see the function; vector used in the shape, see ggplot2 tutorial.}

\item{\code{taxa_text_color}}{default "firebrick1"; taxa text colors.}

\item{\code{taxa_text_type}}{default "italic"; taxa text style; better to use "italic" for Genus, use "normal" for others.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_rda(plot_color = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_mantel"></a>}}
\if{latex}{\out{\hypertarget{method-cal_mantel}{}}}
\subsection{Method \code{cal_mantel()}}{
Mantel test between beta diversity matrix and environmental data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_mantel(
  select_env_data = NULL,
  partial_mantel = FALSE,
  add_matrix = NULL,
  use_measure = NULL,
  method = "pearson",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{select_env_data}}{default NULL; numeric or character vector to select columns in env_data; if not provided, automatically select the columns with numeric attributes.}

\item{\code{partial_mantel}}{default FALSE; whether use partial mantel test; If TRUE, use other measurements as the zdis.}

\item{\code{add_matrix}}{default NULL; additional distance matrix provided, if you donot want to use the beta diversity matrix in the dataset.}

\item{\code{use_measure}}{default NULL; name of beta diversity matrix. If necessary and not provided, use the first beta diversity matrix.}

\item{\code{method}}{default "pearson"; one of "pearson", "spearman" and "kendall"; correlation method.}

\item{\code{...}}{paremeters pass to \code{\link{mantel}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_mantel in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_mantel(use_measure = "bray")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_cor"></a>}}
\if{latex}{\out{\hypertarget{method-cal_cor}{}}}
\subsection{Method \code{cal_cor()}}{
Calculating the correlations between taxa abundance and environmental variables.
Indeed, it can also be used for calculating other correlation between any two variables from two tables.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$cal_cor(
  use_data = c("Genus", "all", "other")[1],
  select_env_data = NULL,
  cor_method = c("pearson", "spearman", "kendall")[1],
  p_adjust_method = "fdr",
  p_adjust_type = c("Type", "Taxa", "Env")[3],
  add_abund_table = NULL,
  by_group = NULL,
  use_taxa_num = NULL,
  other_taxa = NULL,
  group_use = NULL,
  group_select = NULL,
  taxa_name_full = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_data}}{default "Genus"; "Genus", "all" or "other"; "Genus" or other taxonomic name: use genus or other taxonomic abundance table in taxa_abund; 
"all": use all merged taxa abundance table; "other": provide additional taxa name with other_taxa parameter which is necessary.}

\item{\code{select_env_data}}{default NULL; numeric or character vector to select columns in env_data; if not provided, automatically select the columns with numeric attributes.}

\item{\code{cor_method}}{default "pearson"; "pearson", "spearman" or "kendall"; correlation method.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method.}

\item{\code{p_adjust_type}}{default "Env"; "Type", "Taxa" or "Env"; p.adjust type; Env: environmental data; Taxa: taxa data; Type: group used.}

\item{\code{add_abund_table}}{default NULL; additional data table to be used. Samples must be rows.}

\item{\code{by_group}}{default NULL; one column name or number in sample_table; calculate correlations for different groups separately.}

\item{\code{use_taxa_num}}{default NULL; integer; a number used to select high abundant taxa; only useful when use_data parameter is a taxonomic level, e.g. "Genus".}

\item{\code{other_taxa}}{default NULL; provide additional taxa, see use_data parameter.}

\item{\code{group_use}}{default NULL; numeric or character vector to select one column in sample_table for selecting samples; together with group_select.}

\item{\code{group_select}}{default NULL; the group name used; will retain samples within the group.}

\item{\code{taxa_name_full}}{default TRUE; Whether retain the complete taxonomic name of taxa.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_cor in object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t2 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group", rf_taxa_level = "Genus")
t1 <- trans_env$new(dataset = dataset, add_data = env_data_16S[, 4:11])
t1$cal_cor(use_data = "other", p_adjust_method = "fdr", other_taxa = t2$res_rf$Taxa[1:40])
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_cor"></a>}}
\if{latex}{\out{\hypertarget{method-plot_cor}{}}}
\subsection{Method \code{plot_cor()}}{
Plot correlation heatmap.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_cor(
  color_vector = c("#00008B", "#102D9B", "#215AAC", "#3288BD", "#66C2A5", "#E6F598",
    "#FFFFBF", "#FED690", "#FDAE61", "#F46D43", "#D53E4F"),
  pheatmap = FALSE,
  filter_feature = NULL,
  ylab_type_italic = FALSE,
  keep_full_name = FALSE,
  keep_prefix = TRUE,
  plot_x_size = 9,
  mylabels_x = NULL,
  font_family = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_vector}}{color pallete.}

\item{\code{pheatmap}}{default FALSE; whether use heatmap with clustering plot.}

\item{\code{filter_feature}}{default NULL; character vector; used to filter features that only have significance labels in the filter_feature vector. 
For example, filter_feature = "" can be used to filter features that only have "", no any "*".}

\item{\code{ylab_type_italic}}{default FALSE; whether use italic type for y lab text.}

\item{\code{keep_full_name}}{default FALSE; whether use the complete taxonomic name.}

\item{\code{keep_prefix}}{default TRUE; whether retain the taxonomic prefix.}

\item{\code{plot_x_size}}{default 9; x axis text size.}

\item{\code{mylabels_x}}{default NULL; provide x axis text labels additionally; only available when pheatmap = TRUE.}

\item{\code{font_family}}{default NULL; font family used in ggplot2; only available when pheatmap = FALSE.}

\item{\code{...}}{paremeters pass to ggplot2::geom_tile or pheatmap, depending on the pheatmap = FALSE or TRUE.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_cor(pheatmap = FALSE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_scatterfit"></a>}}
\if{latex}{\out{\hypertarget{method-plot_scatterfit}{}}}
\subsection{Method \code{plot_scatterfit()}}{
Scatter plot and add fitted line. The most important thing is to make sure that the input x and y
 have correponding sample orders. If one of x and y is a matrix, the other will be also transformed to matrix with Euclidean distance.
 Then, both of them are transformed to be vectors. If x or y is a vector with a single value, x or y will be
 assigned according to the column selection of the env_data inside.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$plot_scatterfit(
  x = NULL,
  y = NULL,
  use_cor = TRUE,
  cor_method = "pearson",
  add_line = TRUE,
  use_se = TRUE,
  text_x_pos = NULL,
  text_y_pos = NULL,
  x_axis_title = "",
  y_axis_title = "",
  pvalue_trim = 4,
  cor_coef_trim = 3,
  lm_fir_trim = 2,
  lm_sec_trim = 2,
  lm_squ_trim = 2,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{default NULL; a single numeric or character value or a vector or a distance matrix used for the x axis.
If x is a single value, it will be used to select the column of env_data inside.
If x is a distance matrix, it will be transformed to be a vector.}

\item{\code{y}}{default NULL; a single numeric or character value or a vector or a distance matrix used for the y axis.
If y is a single value, it will be used to select the column of env_data inside.
If y is a distance matrix, it will be transformed to be a vector.}

\item{\code{use_cor}}{default TRUE; TRUE for correlation; FALSE for regression.}

\item{\code{cor_method}}{default "pearson"; one of "pearson", "kendall" and "spearman".}

\item{\code{add_line}}{default TRUE; whether add the fitted line in the plot.}

\item{\code{use_se}}{default TRUE; Whether show the confidence interval for the fitting.}

\item{\code{text_x_pos}}{default NULL; the central x axis position of the fitting text.}

\item{\code{text_y_pos}}{default NULL; the central y axis position of the fitting text.}

\item{\code{x_axis_title}}{default ""; the title of x axis.}

\item{\code{y_axis_title}}{default ""; the title of y axis.}

\item{\code{pvalue_trim}}{default 4; trim the decimal places of p value.}

\item{\code{cor_coef_trim}}{default 3; trim the decimal places of correlation coefficient.}

\item{\code{lm_fir_trim}}{default 2; trim the decimal places of regression first coefficient.}

\item{\code{lm_sec_trim}}{default 2; trim the decimal places of regression second coefficient.}

\item{\code{lm_squ_trim}}{default 2; trim the decimal places of regression R square.}

\item{\code{...}}{the parameters passing to ggplot2::geom_point function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
plot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_scatterfit(x = 1, y = 2, alpha = .5)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_env object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_env$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
