% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_unique_by_structure.R
\name{make_unique_by_structure}
\alias{make_unique_by_structure}
\title{Ensure Uniqueness of Coordinates or Values in 1D, 2D, or 3D Structures}
\usage{
make_unique_by_structure(M)
}
\arguments{
\item{M}{A numeric vector, matrix, or data frame with 1, 2, or 3 columns.
For matrices or data frames, columns are interpreted as spatial
(\code{x}, \code{y}) and optional temporal (\code{t}) coordinates.}
}
\value{
If \code{M} is a vector, a numeric vector of the same length is returned.
If \code{M} is a matrix or data frame, a numeric matrix with the same
dimensions is returned, with standardized column names:
\code{"t"} (1D), \code{"x", "y"} (2D), or \code{"x", "y", "t"} (3D).
}
\description{
This function enforces uniqueness in numeric data structures of dimension
one, two, or three by applying minimal perturbations to duplicated values.
It is primarily intended to avoid degeneracy issues (e.g., duplicated
coordinates or time stamps) in spatial and spatio-temporal modeling.
}
\details{
Depending on the dimensionality of the input, uniqueness is enforced as follows:
\itemize{
  \item \strong{1D}: duplicated values are slightly perturbed to ensure uniqueness;
  \item \strong{2D}: duplicated \eqn{(x, y)} coordinate pairs are resolved by perturbing
        the second coordinate;
  \item \strong{3D}: duplicated \eqn{(x, y)} pairs and duplicated temporal coordinates
        are handled separately, ensuring uniqueness in both space and time.
}

The perturbation magnitude is proportional to machine precision and the
scale of the input data, ensuring numerical stability while preserving the
original structure as closely as possible.


This function is designed as a low-level utility for preprocessing spatial
or spatio-temporal inputs prior to kernel-based local regression or distance
computations, where duplicated locations or timestamps may cause numerical
singularities.
}
