% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp_step.R
\name{fit_linear_step}
\alias{fit_linear_step}
\title{Function to fit linear model for variable of interest}
\usage{
fit_linear_step(x, xi, y, powers_current, powers, acdx, ...)
}
\arguments{
\item{x}{an input matrix of dimensions nobs x nvars. Does not contain
intercept, but columns are already expanded into dummy variables as
necessary. Data are assumed to be shifted and scaled.}

\item{xi}{a character string indicating the name of the current variable
of interest, for which the best fractional polynomial transformation is
to be estimated in the current step.}

\item{y}{a vector for the response variable or a \code{Surv} object.}

\item{powers_current}{a list of length equal to the number of variables,
indicating the fp powers to be used in the current step for all variables
(except \code{xi}).}

\item{powers}{a named list of numeric values that sets the permitted FP
powers for each covariate.}

\item{acdx}{a logical vector of length nvars indicating continuous variables
to undergo the approximate cumulative distribution (ACD) transformation.}

\item{...}{passed to \code{fit_model()}.}
}
\value{
A list with two entries:
\itemize{
\item \code{powers}: fp power(s) of \code{xi} (or its ACD transformation) in fitted model.
\item \code{metrics}: a matrix with performance indices for fitted model.
}
}
\description{
"Linear" model here refers to a model which includes the variable
of interest \code{xi} with a fp power of 1. Note that \code{xi} may be ACD transformed
if indicated by \code{acdx[xi]}.
For parameter definitions, see \code{\link[=find_best_fp_step]{find_best_fp_step()}}. All parameters
captured by \code{...} are passed on to \code{\link[=fit_model]{fit_model()}}.
}
