% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/social.R
\name{meta_social}
\alias{meta_social}
\title{Social Media Metadata}
\usage{
meta_social(
  .meta = meta(),
  title = NULL,
  url = NULL,
  image = NULL,
  image_alt = NULL,
  image_width = NULL,
  image_height = NULL,
  description = NULL,
  twitter_card_type = c("summary", "summary_large_image", "app", "player"),
  twitter_creator = NULL,
  twitter_site = twitter_creator,
  og_type = "website",
  og_locale = "en_US",
  og_author = NULL,
  og_site_name = NULL,
  facebook_app_id = NULL,
  disable_pinterest = FALSE
)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{title}{Content title}

\item{url}{Content URL}

\item{image}{Image url for card.}

\item{image_alt}{A description of what's in the image (not a caption)}

\item{image_width}{The width of the image in pixels}

\item{image_height}{The height of the image in pixels}

\item{description}{Content description. If you have already used
\code{\link[=meta_general]{meta_general()}} to set the content's description, that description will
automatically be used.}

\item{twitter_card_type}{One of \code{"summary"}, \code{"summary_large_image"},
\code{"app"}, or \code{"player"}.}

\item{twitter_creator}{\verb{@username} for the content creator / author.}

\item{twitter_site}{\verb{@username`` for the website used in the card footer. }twitter_creator` is used by default.}

\item{og_type}{Open Graph card type, default is \code{"website"}. Other common
options include \code{"article"}, \code{"book"}, or \code{"profile"}. The full list of
valid options can be referenced at \url{https://ogp.me/}}

\item{og_locale}{The locale these tags are marked up in. Of the format \code{language_TERRITORY}. Default is \code{"en_US"}.}

\item{og_author}{Writers of the article. Multiple authors may be specified in
a vector of character strings.}

\item{og_site_name}{The name of the site hosting the content}

\item{facebook_app_id}{The Facebook app ID. See the
\href{https://developers.facebook.com/docs/sharing/webmasters#markup}{Facebook Open Graph Markup}
page for more information.}

\item{disable_pinterest}{If \code{TRUE}, adds a metadata tag disabling pins from
your website. See the
\href{https://help.pinterest.com/en/business/article/prevent-saves-to-pinterest-from-your-site}{Pinterest help center}
for more information.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Generate metadata tags for social media cards.
}
\examples{
meta() \%>\%
  meta_social(
    title = "R for Data Science",
    description = "This book with teach you how to do data science with R",
    url = "https://r4ds.had.co.nz",
    image = "https://r4ds.had.co.nz/cover.png",
    image_alt = "The cover of the R4DS book",
    og_type = "book",
    og_author = c("Garrett Grolemund", "Hadley Wickham"),
    twitter_card_type = "summary",
    twitter_creator = "@hadley"
  )

}
\references{
\itemize{
\item \href{https://ogp.me/}{Open Graph}
\item \href{https://search.google.com/structured-data/testing-tool}{Google Structured Data Testing Tool}
\item \href{https://developers.facebook.com/tools/debug/}{Facebook Sharing Debugger}
\item \href{https://developer.twitter.com/en/docs/twitter-for-websites/cards/guides/getting-started}{Twitter Card Documentation}
\item \href{https://cards-dev.twitter.com/validator}{Twitter Card Validator}
}
}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_google_scholar}()},
\code{\link{meta_name}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
