% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clust_fns_list.R
\name{clust_fns_list}
\alias{clust_fns_list}
\title{Build a clustering algorithms list}
\usage{
clust_fns_list(clust_fns = NULL, use_default_clust_fns = FALSE)
}
\arguments{
\item{clust_fns}{A list of named clustering functions}

\item{use_default_clust_fns}{If TRUE, prepend the base clustering algorithms
(spectral_eigen and spectral_rot, which apply spectral clustering and use
the eigen-gap and rotation cost heuristics respectively for determining
the number of clusters in the graph) to clust_fns.}
}
\value{
A list of clustering algorithm functions that can
be passed into the batch_snf and generate_settings_list functions.
}
\description{
This function can be used to specify custom clustering algorithms to apply
to the final similarity matrices produced by each run of the batch_snf
function.
}
\examples{
# Using just the base clustering algorithms --------------------------------
# This will just contain spectral_eigen and spectral_rot
cfl <- clust_fns_list(use_default_clust_fns = TRUE)

# Adding algorithms provided by the package --------------------------------
# This will contain the base clustering algorithms (spectral_eigen,
#  spectral_rot) as well as two pre-defined spectral clustering functions
#  that force the number of clusters to be two or five
cfl <- clust_fns_list(
     clust_fns = list(
        "two_cluster_spectral" = spectral_two,
        "five_cluster_spectral" = spectral_five
    )
)

# Adding your own algorithms -----------------------------------------------
# This will contain the base and user-provided clustering algorithms
my_clustering_algorithm <- function(similarity_matrix) {
    # your code that converts similarity matrix to clusters here...
}

# Suppress the base algorithms----------------------------------------------
# This will contain only user-provided clustering algorithms
cfl <- clust_fns_list(
    clust_fns = list(
        "two_cluster_spectral" = spectral_two,
        "five_cluster_spectral" = spectral_five
    )
)
}
