% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/traffic_light.R
\name{traffic_light}
\alias{traffic_light}
\title{Produce traffic light plot of risk of bias assessment}
\usage{
traffic_light(object, colour = "cochrane", psize = 15, quiet = FALSE)
}
\arguments{
\item{object}{An object of class \code{rob}.}

\item{colour}{Specify colour scheme for the traffic light plot; see
\code{\link[robvis]{rob_summary}}.}

\item{psize}{Size of the traffic lights.}

\item{quiet}{A logical to suppress the display of the traffic light
plot.}
}
\description{
Produce traffic light plot of risk of bias assessment
}
\details{
This is a wrapper function for
\code{\link[robvis]{rob_traffic_light}} of R package \bold{robvis}
to produce a traffic light plot of risk of bias assessment.
}
\examples{
# Use RevMan 5 settings
oldset <- settings.meta("RevMan5")

data(caffeine)

m1 <- metabin(h.caf, n.caf, h.decaf, n.decaf, sm = "OR",
  data = caffeine, studlab = paste(study, year))

# Add risk of bias assessment to meta-analysis
m2 <- rob(D1, D2, D3, D4, D5, overall = rob, data = m1, tool = "rob2")

# Print risk of bias assessment
rob(m2)

\dontrun{
# Traffic light plot (R package 'robvis' must be available)
if (requireNamespace("robvis", quietly = TRUE))
 traffic_light(rob(m2))
}

# Use previous settings
settings.meta(oldset)

}
\seealso{
\code{\link{rob}}, \code{\link{barplot.rob}},
  \code{\link[robvis]{rob_traffic_light}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
\keyword{hplot}
