% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest_mapWoodyTables.R
\name{forest_mapWoodyTables}
\alias{forest_mapWoodyTables}
\alias{forest_mapTreeTable}
\alias{forest_mapShrubTable}
\title{Map forest plot data}
\usage{
forest_mapTreeTable(x, mapping_x, SpParams, plot_size_x = NULL)

forest_mapShrubTable(y, mapping_y, SpParams, plot_size_y = NULL)

forest_mapWoodyTables(
  x = NULL,
  y = NULL,
  mapping_x = NULL,
  mapping_y = NULL,
  SpParams,
  plot_size_x = NULL,
  plot_size_y = NULL
)
}
\arguments{
\item{x}{A data frame with tree records in rows and attributes in columns. Tree records can correspond to individual trees or groups of trees with an associated density.}

\item{mapping_x}{A named character vector to specify mappings of columns in \code{x} into attributes of \code{treeData} data frames. Accepted names (and the corresponding specifications for the columns in \code{x}) are:}

\item{SpParams}{A data frame with species parameters (see \code{\link{SpParamsMED}}) from which valid species names are drawn.}

\item{plot_size_x}{The size of tree plot sampled area (in m2). Alternatively, 'plot_size_x'
can be a column in \code{x} and specified in \code{mapping_x} to indicate that trees
have been measured in different subplots and, therefore, they represent different
densities per hectare.}

\item{y}{A data frame with shrub records in rows and attributes in columns. Records can correspond to individual shrubs (with crown dimensions and height) or groups of shrubs with an associated cover estimate.}

\item{mapping_y}{A named character vector to specify mappings of columns in \code{y} into attributes of \code{shrubData} data frames.
Accepted names (and the corresponding specifications for the columns in \code{y}) are:
\itemize{
\item{\code{Species}: Species code (should follow codes in \code{SpParams}).}
\item{\code{Species.name}: Species name. In this case, the species code will be drawn by matching names with species names in \code{SpParams}.}
\item{\code{N}: Tree density (in individuals per ha).}
\item{\code{Cover}: Shrub cover (in percent).}
\item{\code{D1}: Shrub largest crown diameter (in cm).}
\item{\code{D2}: Shrub crown diameter orthogonal to the largest one (in cm).}
\item{\code{plot.size}: Plot size (in m2) to which each record refers to. This is used to calculate tree density (stems per hectare) when not supplied or shrub cover when shrub data is given at the individual level.}
\item{\code{DBH}: Diameter at breast height (in cm).}
\item{\code{Height}: Tree or shrub height (in cm).}
\item{\code{Z50}: Depth (in mm) corresponding to 50 percent of fine roots.}
\item{\code{Z95}: Depth (in mm) corresponding to 95 percent of fine roots.}
}}

\item{plot_size_y}{The size of shrub plot sampled area (in m2). Alternatively, 'plot_size_y'
can be a column in \code{y} and specified in \code{mapping_y} to indicate that shrubs
have been measured in different subplots and, therefore, they represent different
cover values.}
}
\value{
Functions \code{forest_mapTreeTable} and \code{forest_mapShrubTable} return a data frame with the structure of \code{treeData} and \code{shrubData} from \code{\link{forest}} objects. Function \code{forest_mapWoodyTable} returns directly a \code{\link{forest}} object.
}
\description{
Mapping functions to facilitate building forest objects from forest plot data
}
\examples{

# Load species parameters
data(SpParamsMED)

# Create an empty forest object
f <- emptyforest()

# (1) Mapping tree data
# Load Poblet tree data
data(poblet_trees)

# Subset control plot
x <- subset(poblet_trees, Plot.Code=="POBL_CTL")

# Estimate sampled area (15-m radius plot)
sampled_area <- pi*15^2

# Define mapping
mapping_x <- c("Species.name" = "Species", "DBH" = "Diameter.cm")

# Map tree data for plot 'POBL_CTL'
f$treeData <- forest_mapTreeTable(x,
                    mapping_x = mapping_x, SpParams = SpParamsMED,
                    plot_size_x = sampled_area)

# (2) Mapping shrub individual data
#
# Create the individual shrub data frame
species <- c("Erica arborea","Cistus albidus", "Erica arborea", "Cistus albidus", "Cistus albidus")
H <- c(200,50,100,40,30)
D1 <- c(140,40,100, 35,30)
D2 <- D1
y <- data.frame(species, H, D1, D2)

# Define mapping (D1 and D2 map to variables with the same name)
mapping_y <- c("Species.name"= "species", "Height" ="H", "D1", "D2")

# Map individual shrub data to cover data (here each individual becomes a cohort)
# assuming that the sampled area was 4 m2
f$shrubData <- forest_mapShrubTable(y,
                     mapping_y = mapping_y, SpParams = SpParamsMED,
                     plot_size_y = 4)

# (3) Print forest attributes
summary(f, SpParamsMED)

# (4) Forest initialization in a single step
f <- forest_mapWoodyTables(x, y,
                           mapping_x = mapping_x, mapping_y = mapping_y,
                           SpParams = SpParamsMED,
                           plot_size_x = sampled_area, plot_size_y = 4)
summary(f, SpParamsMED)
}
\seealso{
\code{\link{forest}}, \code{\link{poblet_trees}}, \code{\link{forest_mergeTrees}}, \code{\link{tree2forest}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, EMF-CREAF
}
