% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/para.est.R
\docType{methods}
\name{para.est}
\alias{para.est}
\alias{para.est,mbsts-method}
\title{Regression parameter estimation by the MBSTS Model}
\usage{
para.est(object, prob.threshold = 0.2)

\S4method{para.est}{mbsts}(object, prob.threshold = 0.2)
}
\arguments{
\item{object}{An object of the mbsts class created by a call to the mbsts_function function.}

\item{prob.threshold}{A numerical value used as the threshold to only include predictors whose inclusion probabilities are higher than it in the plot. The default is \eqn{0.2}.#' @param prob.threshold A numerical value used as the threshold to only include predictors whose inclusion probabilities are higher than it in the plot. The default value is \eqn{0.2}.}
}
\value{
A list with the following components
\item{index}{An array of feature selection results.}
\item{para.est.mean}{An array of means of parameter estimation values of selected features.}
\item{para.est.sd}{An array of standard deviations of parameter estimation values of selected features.}
}
\description{
Generate feature selection and parameter estimation results of a mbsts object. Provide means and standard deviations of parameter estimation results for selected features.
}
\references{
\Qiu2018

\Ning2021

\Jammalamadaka2019
}
\author{
Jinwen Qiu \email{qjwsnow_ctw@hotmail.com} Ning Ning \email{patricianing@gmail.com}
}
