% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/product.R, R/rowProds.R
\name{product}
\alias{product}
\alias{rowProds}
\alias{colProds}
\title{Calculates the product for each row (column) in a matrix}
\usage{
product(x, idxs = NULL, na.rm = FALSE, ...)

rowProds(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  method = c("direct", "expSumLog"),
  ...
)

colProds(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  method = c("direct", "expSumLog"),
  ...
)
}
\arguments{
\item{x}{A \code{\link[base]{numeric}} NxK \code{\link[base]{matrix}}.}

\item{idxs, rows, cols}{A \code{\link[base]{vector}} indicating subset of
elements (or rows and/or columns) to operate over. If
\code{\link[base]{NULL}}, no subsetting is done.}

\item{na.rm}{If \code{\link[base:logical]{TRUE}}, missing values are
ignored, otherwise not.}

\item{...}{Not used.}

\item{method}{A \code{\link[base]{character}} string specifying how each
product is calculated.}
}
\value{
Returns a \code{\link[base]{numeric}} \code{\link[base]{vector}} of
length N (K).
}
\description{
Calculates the product for each row (column) in a matrix.
}
\details{
If \code{method = "expSumLog"}, then then \code{\link{product}}() function is
used, which calculates the produce via the logarithmic transform (treating
negative values specially).  This improves the precision and lowers the risk
for numeric overflow.  If \code{method = "direct"}, the direct product is
calculated via the \code{\link[base]{prod}}() function.
}
\section{Missing values}{

Note, if \code{method = "expSumLog"}, \code{na.rm = FALSE}, and \code{x}
contains missing values (\code{\link[base]{NA}} or
\code{\link[base:is.finite]{NaN}}), then the calculated value is also
missing value.  Note that it depends on platform whether
\code{\link[base:is.finite]{NaN}} or \code{\link[base]{NA}} is returned
when an \code{\link[base:is.finite]{NaN}} exists, cf.
\code{\link[base]{is.nan}}().
}

\author{
Henrik Bengtsson
}
\keyword{array}
\keyword{iteration}
\keyword{robust}
\keyword{univar}
